#region Using statements

using System;
using System.Collections;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using gov.va.med.vbecs.Common;
using System.Text;

#endregion

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Luke Meyer</Developer>
	///	<Developer>Cameron Taylor</Developer>
	///	<Developer>Keith Franklin</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>4/30/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Provides the user interface to add blood units to an incoming shipment</summary>
	public class FrmProcessShipmentIn : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// This collection has a BloodUnitGuid as it's key and the modification Hashtable
		/// as it's value.
		/// </summary>
		private Hashtable specialTestingHash;

		private System.Collections.ArrayList _alDonationTypeList;
		private System.Collections.ArrayList _alTestingStatusList;
		private int _cmvNeg;
		private int _sickleCell;
		private bool _reenteredUnit = false;
		private const Common.WorkloadProcessID _workloadProcessID = Common.WorkloadProcessID.UnitLogin;
		private string _listItem = string.Empty;
		private bool _retValVerifyExistingUnit = false;

		/// <summary>
		/// This Hashtable is for the special testing fields.  The key is either (CMV) of 
		/// (Sickle Cell).  The value is a boolean that indicates the results of the testing. 
		/// </summary>
		private Hashtable modificationsHash;

		/// <summary>
		/// Holds antigen modifications
		/// </summary>
		/// 
		private System.Collections.ArrayList _alBloodUnitAntigens;
		
		/// <summary>
		/// Holds tool tip text for the OK button
		/// </summary>
		string okButtonToolTipText;

		/// <summary>
		/// Counter to tell how many times the Collection facility has been checked
		/// </summary>
		private short collectionFacilityChecked = 0;

		/// <summary>
		/// Tells what type of barcoding schema the unit has
		/// </summary>
		private bool codabar;

		/// <summary>
		/// Holds information about the shipment for the blood unit
		/// </summary>
		private BOL.IncomingShipment _shipment;

		private string _processingTechID;
		
		/// <summary>
		/// Holds information about a blood unit
		/// </summary>
		private BOL.BloodUnit _bloodUnit;
		private BOL.BloodProduct _bloodProduct;
		private BOL.LocalSupplier _localSupplier;
		private MultipleBloodProductCode _multipleBloodProductCode;

		/// <summary>
		/// This is a flag that prevents certain events from firing when the form is loading.
		/// </summary>
		private bool _isLoading = false;
		private bool _isUnloading = false;
		private bool _transferredOutandInConfirmed = false;
		
		private System.Windows.Forms.Panel pnlAddUnit;
		private System.Windows.Forms.Panel pnlUnitSelect;
		private System.Windows.Forms.GroupBox grpAddUnit;
		private System.Windows.Forms.Panel pnlShipmentUnits;
		private System.Windows.Forms.GroupBox grpShipmentUnits;
		private System.Windows.Forms.ListView lvShipmentUnits;
		private ToolTip ttProduct; 
		private System.Windows.Forms.Timer tmrToolTips;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private gov.va.med.vbecs.GUI.controls.InvoiceDisplayPanel invoiceDisplayPanel1;
		private System.Windows.Forms.Button btnCancel;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.ColumnHeader unitID;
		private System.Windows.Forms.ColumnHeader aboRh;
		private System.Windows.Forms.ColumnHeader product;
		private System.Windows.Forms.ColumnHeader expDate;
		private System.Windows.Forms.ColumnHeader type;
		private System.Windows.Forms.ColumnHeader restricted;
		private System.Windows.Forms.ColumnHeader specialTesting;
		private System.Windows.Forms.Panel pnlUnitDefine;
		private gov.va.med.vbecs.GUI.controls.AboRHComboBox cmbABORh;
		private gov.va.med.vbecs.GUI.controls.ExpirationDateComboBox dtpExpiration;
		private gov.va.med.vbecs.GUI.controls.UnitIDTextbox txtUnitID;
		private System.Windows.Forms.Label lblExpiration;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.Label lblABORh;
		private System.Windows.Forms.PictureBox pictureBox6;
		private System.Windows.Forms.PictureBox pictureBox4;
		private System.Windows.Forms.PictureBox pictureBox3;
		private System.Windows.Forms.Panel pnlDonation;
		private System.Windows.Forms.GroupBox grpTypeExtended;
		private System.Windows.Forms.Panel pnlStatus;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTestingStatus;
		private System.Windows.Forms.Label lblStatus;
		private System.Windows.Forms.Panel pnlRestricted;
		private System.Windows.Forms.Label lblRestricted;
		private System.Windows.Forms.Button btnSelectPatient;
		private System.Windows.Forms.TextBox txtPatient;
		private System.Windows.Forms.Label lblDonationType;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbType;
		private System.Windows.Forms.Panel pnlSpecialTesting;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAdd;
		private gov.va.med.vbecs.GUI.controls.SpecialTesting specialTesting1;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.TextBox txtCheckCharacter;
		private System.Windows.Forms.Label lblSpaceHolder;
		private gov.va.med.vbecs.GUI.controls.BloodUnitLabel bloodUnitLabel1;
		private System.Windows.Forms.PictureBox pictureBox2;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtFDAReg;
		private System.Windows.Forms.Label lblFDAReg;
		private System.Windows.Forms.Label lblProduct;
		private System.Windows.Forms.PictureBox pictureBox5;
		private gov.va.med.vbecs.GUI.controls.ProductCodeTextbox txtProduct;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.GroupBox grpRestrictedFor;
		private System.Windows.Forms.GroupBox grpSpecialTestingCost;
		private System.Windows.Forms.Button btnFDARegNo;
		private System.Windows.Forms.Button btnProductCode;
		private System.Windows.Forms.Label label1;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updSpecialTestingCost;
		private System.Windows.Forms.Panel pnlUnit;
		private System.Windows.Forms.Label lblSpecialTestCost;
		

        
		#endregion

		#region Constructor

		/// <summary>
		/// Constructor for the form
		/// </summary>	
		///<Developers>
		///<Developer>Cameron Taylor</Developer>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/30/2002</CreationDate>
		///
		public FrmProcessShipmentIn(bool isCodabar)
		{
			this.IsDirty = false;
			this._cmvNeg = System.Convert.ToInt32(Common.TestType.CMV);
			this._sickleCell = System.Convert.ToInt32(Common.TestType.SickleCell);
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			
			this.Codabar = isCodabar;
			SetComponentProperties();
			LoadLists();
			SetUpFormNewBloodUnit();
		}

		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmProcessShipmentIn));
			this.pnlAddUnit = new System.Windows.Forms.Panel();
			this.pnlUnitSelect = new System.Windows.Forms.Panel();
			this.pnlShipmentUnits = new System.Windows.Forms.Panel();
			this.grpShipmentUnits = new System.Windows.Forms.GroupBox();
			this.lvShipmentUnits = new System.Windows.Forms.ListView();
			this.unitID = new System.Windows.Forms.ColumnHeader();
			this.aboRh = new System.Windows.Forms.ColumnHeader();
			this.product = new System.Windows.Forms.ColumnHeader();
			this.expDate = new System.Windows.Forms.ColumnHeader();
			this.type = new System.Windows.Forms.ColumnHeader();
			this.restricted = new System.Windows.Forms.ColumnHeader();
			this.specialTesting = new System.Windows.Forms.ColumnHeader();
			this.pnlUnit = new System.Windows.Forms.Panel();
			this.grpAddUnit = new System.Windows.Forms.GroupBox();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlDonation = new System.Windows.Forms.Panel();
			this.grpSpecialTestingCost = new System.Windows.Forms.GroupBox();
			this.updSpecialTestingCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.label1 = new System.Windows.Forms.Label();
			this.lblSpecialTestCost = new System.Windows.Forms.Label();
			this.grpRestrictedFor = new System.Windows.Forms.GroupBox();
			this.pnlRestricted = new System.Windows.Forms.Panel();
			this.lblRestricted = new System.Windows.Forms.Label();
			this.btnSelectPatient = new System.Windows.Forms.Button();
			this.txtPatient = new System.Windows.Forms.TextBox();
			this.grpTypeExtended = new System.Windows.Forms.GroupBox();
			this.pnlStatus = new System.Windows.Forms.Panel();
			this.cmbTestingStatus = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblStatus = new System.Windows.Forms.Label();
			this.lblDonationType = new System.Windows.Forms.Label();
			this.cmbType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.bloodUnitLabel1 = new gov.va.med.vbecs.GUI.controls.BloodUnitLabel(this.components);
			this.pnlSpecialTesting = new System.Windows.Forms.Panel();
			this.btnAdd = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.specialTesting1 = new gov.va.med.vbecs.GUI.controls.SpecialTesting();
			this.btnClear = new System.Windows.Forms.Button();
			this.pnlUnitDefine = new System.Windows.Forms.Panel();
			this.btnProductCode = new System.Windows.Forms.Button();
			this.btnFDARegNo = new System.Windows.Forms.Button();
			this.lblFDAReg = new System.Windows.Forms.Label();
			this.lblProduct = new System.Windows.Forms.Label();
			this.pictureBox5 = new System.Windows.Forms.PictureBox();
			this.txtProduct = new gov.va.med.vbecs.GUI.controls.ProductCodeTextbox(this.components);
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.txtFDAReg = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.lblSpaceHolder = new System.Windows.Forms.Label();
			this.txtCheckCharacter = new System.Windows.Forms.TextBox();
			this.pictureBox6 = new System.Windows.Forms.PictureBox();
			this.pictureBox4 = new System.Windows.Forms.PictureBox();
			this.pictureBox3 = new System.Windows.Forms.PictureBox();
			this.cmbABORh = new gov.va.med.vbecs.GUI.controls.AboRHComboBox(this.components);
			this.dtpExpiration = new gov.va.med.vbecs.GUI.controls.ExpirationDateComboBox(this.components);
			this.txtUnitID = new gov.va.med.vbecs.GUI.controls.UnitIDTextbox(this.components);
			this.lblExpiration = new System.Windows.Forms.Label();
			this.lblUnitID = new System.Windows.Forms.Label();
			this.lblABORh = new System.Windows.Forms.Label();
			this.invoiceDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.InvoiceDisplayPanel();
			this.btnCancel = new System.Windows.Forms.Button();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.ttProduct = new System.Windows.Forms.ToolTip(this.components);
			this.tmrToolTips = new System.Windows.Forms.Timer(this.components);
			this.pnlAddUnit.SuspendLayout();
			this.pnlUnitSelect.SuspendLayout();
			this.pnlShipmentUnits.SuspendLayout();
			this.grpShipmentUnits.SuspendLayout();
			this.pnlUnit.SuspendLayout();
			this.grpAddUnit.SuspendLayout();
			this.pnlDonation.SuspendLayout();
			this.grpSpecialTestingCost.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updSpecialTestingCost)).BeginInit();
			this.grpRestrictedFor.SuspendLayout();
			this.pnlRestricted.SuspendLayout();
			this.grpTypeExtended.SuspendLayout();
			this.pnlStatus.SuspendLayout();
			this.pnlSpecialTesting.SuspendLayout();
			this.pnlUnitDefine.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 507);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// errError
			// 
			this.errError.BlinkStyle = System.Windows.Forms.ErrorBlinkStyle.NeverBlink;
			this.errError.DataMember = "";
			// 
			// pnlAddUnit
			// 
			this.pnlAddUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlAddUnit.Controls.Add(this.pnlUnitSelect);
			this.pnlAddUnit.Controls.Add(this.invoiceDisplayPanel1);
			this.pnlAddUnit.Location = new System.Drawing.Point(0, 32);
			this.pnlAddUnit.Name = "pnlAddUnit";
			this.pnlAddUnit.Size = new System.Drawing.Size(742, 460);
			this.pnlAddUnit.TabIndex = 0;
			// 
			// pnlUnitSelect
			// 
			this.pnlUnitSelect.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlUnitSelect.Controls.Add(this.pnlShipmentUnits);
			this.pnlUnitSelect.Controls.Add(this.pnlUnit);
			this.pnlUnitSelect.Location = new System.Drawing.Point(0, 40);
			this.pnlUnitSelect.Name = "pnlUnitSelect";
			this.pnlUnitSelect.Size = new System.Drawing.Size(742, 424);
			this.pnlUnitSelect.TabIndex = 0;
			// 
			// pnlShipmentUnits
			// 
			this.pnlShipmentUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlShipmentUnits.Controls.Add(this.grpShipmentUnits);
			this.pnlShipmentUnits.Location = new System.Drawing.Point(0, 228);
			this.pnlShipmentUnits.Name = "pnlShipmentUnits";
			this.pnlShipmentUnits.Size = new System.Drawing.Size(742, 192);
			this.pnlShipmentUnits.TabIndex = 1;
			// 
			// grpShipmentUnits
			// 
			this.grpShipmentUnits.AccessibleDescription = "Shipment Units";
			this.grpShipmentUnits.AccessibleName = "Shipment Units";
			this.grpShipmentUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpShipmentUnits.Controls.Add(this.lvShipmentUnits);
			this.grpShipmentUnits.Location = new System.Drawing.Point(4, 0);
			this.grpShipmentUnits.Name = "grpShipmentUnits";
			this.grpShipmentUnits.Size = new System.Drawing.Size(736, 192);
			this.grpShipmentUnits.TabIndex = 17;
			this.grpShipmentUnits.TabStop = false;
			this.grpShipmentUnits.Text = "Shipment Units";
			// 
			// lvShipmentUnits
			// 
			this.lvShipmentUnits.AccessibleDescription = "Shipment Units";
			this.lvShipmentUnits.AccessibleName = "Shipment Units";
			this.lvShipmentUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvShipmentUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.unitID,
																							  this.aboRh,
																							  this.product,
																							  this.expDate,
																							  this.type,
																							  this.restricted,
																							  this.specialTesting});
			this.lvShipmentUnits.FullRowSelect = true;
			this.lvShipmentUnits.Location = new System.Drawing.Point(8, 20);
			this.lvShipmentUnits.MultiSelect = false;
			this.lvShipmentUnits.Name = "lvShipmentUnits";
			this.lvShipmentUnits.Size = new System.Drawing.Size(720, 168);
			this.lvShipmentUnits.TabIndex = 18;
			this.lvShipmentUnits.View = System.Windows.Forms.View.Details;
			this.lvShipmentUnits.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvShipmentUnits_ColumnClick);
			// 
			// unitID
			// 
			this.unitID.Text = "Unit ID";
			this.unitID.Width = 80;
			// 
			// aboRh
			// 
			this.aboRh.Text = "ABO/Rh";
			this.aboRh.Width = 65;
			// 
			// product
			// 
			this.product.Text = "Product";
			this.product.Width = 170;
			// 
			// expDate
			// 
			this.expDate.Text = "Expires";
			this.expDate.Width = 110;
			// 
			// type
			// 
			this.type.Text = "Donation Type";
			this.type.Width = 95;
			// 
			// restricted
			// 
			this.restricted.Text = "Restricted For";
			this.restricted.Width = 100;
			// 
			// specialTesting
			// 
			this.specialTesting.Text = "Special Testing";
			this.specialTesting.Width = 300;
			// 
			// pnlUnit
			// 
			this.pnlUnit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlUnit.Controls.Add(this.grpAddUnit);
			this.pnlUnit.Location = new System.Drawing.Point(0, 0);
			this.pnlUnit.Name = "pnlUnit";
			this.pnlUnit.Size = new System.Drawing.Size(742, 224);
			this.pnlUnit.TabIndex = 0;
			// 
			// grpAddUnit
			// 
			this.grpAddUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAddUnit.Controls.Add(this.splitter1);
			this.grpAddUnit.Controls.Add(this.pnlDonation);
			this.grpAddUnit.Controls.Add(this.bloodUnitLabel1);
			this.grpAddUnit.Controls.Add(this.pnlSpecialTesting);
			this.grpAddUnit.Controls.Add(this.pnlUnitDefine);
			this.grpAddUnit.Location = new System.Drawing.Point(4, 0);
			this.grpAddUnit.Name = "grpAddUnit";
			this.grpAddUnit.Size = new System.Drawing.Size(736, 220);
			this.grpAddUnit.TabIndex = 0;
			this.grpAddUnit.TabStop = false;
			// 
			// splitter1
			// 
			this.splitter1.Dock = System.Windows.Forms.DockStyle.Right;
			this.splitter1.Location = new System.Drawing.Point(570, 16);
			this.splitter1.MinSize = 160;
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 201);
			this.splitter1.TabIndex = 3;
			this.splitter1.TabStop = false;
			// 
			// pnlDonation
			// 
			this.pnlDonation.Controls.Add(this.grpSpecialTestingCost);
			this.pnlDonation.Controls.Add(this.grpRestrictedFor);
			this.pnlDonation.Controls.Add(this.grpTypeExtended);
			this.pnlDonation.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlDonation.Location = new System.Drawing.Point(410, 16);
			this.pnlDonation.Name = "pnlDonation";
			this.pnlDonation.Size = new System.Drawing.Size(163, 201);
			this.pnlDonation.TabIndex = 2;
			// 
			// grpSpecialTestingCost
			// 
			this.grpSpecialTestingCost.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSpecialTestingCost.Controls.Add(this.updSpecialTestingCost);
			this.grpSpecialTestingCost.Controls.Add(this.label1);
			this.grpSpecialTestingCost.Controls.Add(this.lblSpecialTestCost);
			this.grpSpecialTestingCost.Location = new System.Drawing.Point(4, 148);
			this.grpSpecialTestingCost.Name = "grpSpecialTestingCost";
			this.grpSpecialTestingCost.Size = new System.Drawing.Size(157, 48);
			this.grpSpecialTestingCost.TabIndex = 2;
			this.grpSpecialTestingCost.TabStop = false;
			// 
			// updSpecialTestingCost
			// 
			this.updSpecialTestingCost.AccessibleDescription = "Special Testing Cost";
			this.updSpecialTestingCost.AccessibleName = "Special Testing Cost";
			this.updSpecialTestingCost.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updSpecialTestingCost.DecimalPlaces = 2;
			this.updSpecialTestingCost.Location = new System.Drawing.Point(24, 24);
			this.updSpecialTestingCost.Maximum = new System.Decimal(new int[] {
																				  999,
																				  0,
																				  0,
																				  0});
			this.updSpecialTestingCost.Name = "updSpecialTestingCost";
			this.updSpecialTestingCost.Size = new System.Drawing.Size(117, 20);
			this.updSpecialTestingCost.TabIndex = 13;
			this.updSpecialTestingCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updSpecialTestingCost.Value = new System.Decimal(new int[] {
																				0,
																				0,
																				0,
																				0});
			this.updSpecialTestingCost.TextChanged += new System.EventHandler(this.updSpecialTestingCost_ValueChanged);
			this.updSpecialTestingCost.Leave += new System.EventHandler(this.updSpecialTestingCost_Leave);
			this.updSpecialTestingCost.ValueChanged += new System.EventHandler(this.updSpecialTestingCost_ValueChanged);
			// 
			// label1
			// 
			this.errError.SetIconAlignment(this.label1, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.label1.Location = new System.Drawing.Point(8, 28);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(16, 16);
			this.label1.TabIndex = 1;
			this.label1.Text = "$";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSpecialTestCost
			// 
			this.lblSpecialTestCost.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.errError.SetIconAlignment(this.lblSpecialTestCost, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.lblSpecialTestCost.Location = new System.Drawing.Point(8, 8);
			this.lblSpecialTestCost.Name = "lblSpecialTestCost";
			this.lblSpecialTestCost.Size = new System.Drawing.Size(141, 16);
			this.lblSpecialTestCost.TabIndex = 0;
			this.lblSpecialTestCost.Text = "Special Testing Cost";
			this.lblSpecialTestCost.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpRestrictedFor
			// 
			this.grpRestrictedFor.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRestrictedFor.Controls.Add(this.pnlRestricted);
			this.grpRestrictedFor.Location = new System.Drawing.Point(4, 96);
			this.grpRestrictedFor.Name = "grpRestrictedFor";
			this.grpRestrictedFor.Size = new System.Drawing.Size(156, 52);
			this.grpRestrictedFor.TabIndex = 1;
			this.grpRestrictedFor.TabStop = false;
			// 
			// pnlRestricted
			// 
			this.pnlRestricted.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlRestricted.Controls.Add(this.lblRestricted);
			this.pnlRestricted.Controls.Add(this.btnSelectPatient);
			this.pnlRestricted.Controls.Add(this.txtPatient);
			this.pnlRestricted.Location = new System.Drawing.Point(8, 8);
			this.pnlRestricted.Name = "pnlRestricted";
			this.pnlRestricted.Size = new System.Drawing.Size(140, 36);
			this.pnlRestricted.TabIndex = 2;
			// 
			// lblRestricted
			// 
			this.lblRestricted.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblRestricted.Location = new System.Drawing.Point(0, 0);
			this.lblRestricted.Name = "lblRestricted";
			this.lblRestricted.Size = new System.Drawing.Size(140, 16);
			this.lblRestricted.TabIndex = 0;
			this.lblRestricted.Text = "Restricted For Patient";
			this.lblRestricted.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSelectPatient
			// 
			this.btnSelectPatient.AccessibleDescription = "Find";
			this.btnSelectPatient.AccessibleName = "Find";
			this.btnSelectPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectPatient.Enabled = false;
			this.btnSelectPatient.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSelectPatient.Location = new System.Drawing.Point(115, 16);
			this.btnSelectPatient.Name = "btnSelectPatient";
			this.btnSelectPatient.Size = new System.Drawing.Size(26, 20);
			this.btnSelectPatient.TabIndex = 12;
			this.btnSelectPatient.Text = "find";
			this.ttProduct.SetToolTip(this.btnSelectPatient, "Click to select the patient that the blood unit has been directed for");
			this.btnSelectPatient.Click += new System.EventHandler(this.btnSelectPatient_Click);
			// 
			// txtPatient
			// 
			this.txtPatient.AccessibleDescription = "Restricted For Patient";
			this.txtPatient.AccessibleName = "Restricted For Patient";
			this.txtPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatient.Enabled = false;
			this.txtPatient.Location = new System.Drawing.Point(0, 16);
			this.txtPatient.MaxLength = 50;
			this.txtPatient.Name = "txtPatient";
			this.txtPatient.ReadOnly = true;
			this.txtPatient.Size = new System.Drawing.Size(114, 20);
			this.txtPatient.TabIndex = 11;
			this.txtPatient.Text = "";
			// 
			// grpTypeExtended
			// 
			this.grpTypeExtended.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTypeExtended.Controls.Add(this.pnlStatus);
			this.grpTypeExtended.Controls.Add(this.lblDonationType);
			this.grpTypeExtended.Controls.Add(this.cmbType);
			this.grpTypeExtended.Location = new System.Drawing.Point(4, 0);
			this.grpTypeExtended.Name = "grpTypeExtended";
			this.grpTypeExtended.Size = new System.Drawing.Size(157, 96);
			this.grpTypeExtended.TabIndex = 0;
			this.grpTypeExtended.TabStop = false;
			// 
			// pnlStatus
			// 
			this.pnlStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlStatus.Controls.Add(this.cmbTestingStatus);
			this.pnlStatus.Controls.Add(this.lblStatus);
			this.pnlStatus.Location = new System.Drawing.Point(8, 48);
			this.pnlStatus.Name = "pnlStatus";
			this.pnlStatus.Size = new System.Drawing.Size(141, 40);
			this.pnlStatus.TabIndex = 2;
			// 
			// cmbTestingStatus
			// 
			this.cmbTestingStatus.AccessibleDescription = "Disease Marker Testing";
			this.cmbTestingStatus.AccessibleName = "Disease Marker Testing";
			this.cmbTestingStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbTestingStatus.DropDownWidth = 200;
			this.cmbTestingStatus.Enabled = false;
			this.cmbTestingStatus.Interval = 500;
			this.cmbTestingStatus.Location = new System.Drawing.Point(0, 16);
			this.cmbTestingStatus.Name = "cmbTestingStatus";
			this.cmbTestingStatus.Size = new System.Drawing.Size(141, 22);
			this.cmbTestingStatus.TabIndex = 10;
			this.ttProduct.SetToolTip(this.cmbTestingStatus, "Select disease marker testing status");
			this.cmbTestingStatus.MouseHover += new System.EventHandler(this.cmbTestingStatus_MouseHover);
			this.cmbTestingStatus.SelectedIndexChanged += new System.EventHandler(this.cmbTestingStatus_SelectedIndexChanged);
			// 
			// lblStatus
			// 
			this.lblStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblStatus.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblStatus.Location = new System.Drawing.Point(0, 0);
			this.lblStatus.Name = "lblStatus";
			this.lblStatus.Size = new System.Drawing.Size(141, 16);
			this.lblStatus.TabIndex = 0;
			this.lblStatus.Text = "Disease Marker Testing";
			// 
			// lblDonationType
			// 
			this.lblDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblDonationType.Location = new System.Drawing.Point(8, 8);
			this.lblDonationType.Name = "lblDonationType";
			this.lblDonationType.Size = new System.Drawing.Size(141, 16);
			this.lblDonationType.TabIndex = 0;
			this.lblDonationType.Text = "Donation Type*";
			this.lblDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbType
			// 
			this.cmbType.AccessibleDescription = "Donation Type";
			this.cmbType.AccessibleName = "Donation Type";
			this.cmbType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbType.DropDownWidth = 200;
			this.cmbType.Interval = 500;
			this.cmbType.Items.AddRange(new object[] {
														 "Homologous",
														 "Autologous",
														 "Directed"});
			this.cmbType.Location = new System.Drawing.Point(8, 24);
			this.cmbType.Name = "cmbType";
			this.cmbType.Size = new System.Drawing.Size(141, 22);
			this.cmbType.TabIndex = 9;
			this.ttProduct.SetToolTip(this.cmbType, "Select donation type of the selected unit");
			this.cmbType.MouseHover += new System.EventHandler(this.cmbType_MouseHover);
			this.cmbType.SelectedIndexChanged += new System.EventHandler(this.cmbType_SelectedIndexChanged);
			// 
			// bloodUnitLabel1
			// 
			this.bloodUnitLabel1.BackColor = System.Drawing.Color.WhiteSmoke;
			this.bloodUnitLabel1.BloodUnit = null;
			this.bloodUnitLabel1.Dock = System.Windows.Forms.DockStyle.Left;
			this.bloodUnitLabel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitLabel1.Location = new System.Drawing.Point(153, 16);
			this.bloodUnitLabel1.Name = "bloodUnitLabel1";
			this.bloodUnitLabel1.Size = new System.Drawing.Size(257, 201);
			this.bloodUnitLabel1.TabIndex = 1;
			this.bloodUnitLabel1.TabStop = false;
			// 
			// pnlSpecialTesting
			// 
			this.pnlSpecialTesting.Controls.Add(this.btnAdd);
			this.pnlSpecialTesting.Controls.Add(this.specialTesting1);
			this.pnlSpecialTesting.Controls.Add(this.btnClear);
			this.pnlSpecialTesting.Dock = System.Windows.Forms.DockStyle.Right;
			this.pnlSpecialTesting.Location = new System.Drawing.Point(573, 16);
			this.pnlSpecialTesting.Name = "pnlSpecialTesting";
			this.pnlSpecialTesting.Size = new System.Drawing.Size(160, 201);
			this.pnlSpecialTesting.TabIndex = 4;
			// 
			// btnAdd
			// 
			this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAdd.EnabledButton = false;
			this.btnAdd.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
			this.btnAdd.Location = new System.Drawing.Point(82, 177);
			this.btnAdd.Name = "btnAdd";
			this.btnAdd.Size = new System.Drawing.Size(75, 23);
			this.btnAdd.TabIndex = 16;
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			this.btnAdd.MouseHover += new System.EventHandler(this.btnAdd_MouseHover);
			// 
			// specialTesting1
			// 
			this.specialTesting1.AccessibleDescription = "Special Testing";
			this.specialTesting1.AccessibleName = "Special Testing";
			this.specialTesting1.AllowUpdate = true;
			this.specialTesting1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.specialTesting1.AntigensEnabled = false;
			this.specialTesting1.BloodUnitGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.specialTesting1.CmvEnabled = false;
			this.specialTesting1.CmvNegative = false;
			this.specialTesting1.DivisionCode = "";
			this.specialTesting1.IsDirty = false;
			this.specialTesting1.Location = new System.Drawing.Point(2, 0);
			this.specialTesting1.Name = "specialTesting1";
			this.specialTesting1.SickleCellEnabled = false;
			this.specialTesting1.SickleCellNegative = false;
			this.specialTesting1.Size = new System.Drawing.Size(156, 172);
			this.specialTesting1.TabIndex = 14;
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.CausesValidation = false;
			this.btnClear.Location = new System.Drawing.Point(2, 177);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 15;
			this.btnClear.Text = "C&lear Unit";
			this.ttProduct.SetToolTip(this.btnClear, "Click to clear current blood unit for re-entry");
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// pnlUnitDefine
			// 
			this.pnlUnitDefine.Controls.Add(this.btnProductCode);
			this.pnlUnitDefine.Controls.Add(this.btnFDARegNo);
			this.pnlUnitDefine.Controls.Add(this.lblFDAReg);
			this.pnlUnitDefine.Controls.Add(this.lblProduct);
			this.pnlUnitDefine.Controls.Add(this.pictureBox5);
			this.pnlUnitDefine.Controls.Add(this.txtProduct);
			this.pnlUnitDefine.Controls.Add(this.pictureBox2);
			this.pnlUnitDefine.Controls.Add(this.txtFDAReg);
			this.pnlUnitDefine.Controls.Add(this.lblSpaceHolder);
			this.pnlUnitDefine.Controls.Add(this.txtCheckCharacter);
			this.pnlUnitDefine.Controls.Add(this.pictureBox6);
			this.pnlUnitDefine.Controls.Add(this.pictureBox4);
			this.pnlUnitDefine.Controls.Add(this.pictureBox3);
			this.pnlUnitDefine.Controls.Add(this.cmbABORh);
			this.pnlUnitDefine.Controls.Add(this.dtpExpiration);
			this.pnlUnitDefine.Controls.Add(this.txtUnitID);
			this.pnlUnitDefine.Controls.Add(this.lblExpiration);
			this.pnlUnitDefine.Controls.Add(this.lblUnitID);
			this.pnlUnitDefine.Controls.Add(this.lblABORh);
			this.pnlUnitDefine.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlUnitDefine.Location = new System.Drawing.Point(3, 16);
			this.pnlUnitDefine.Name = "pnlUnitDefine";
			this.pnlUnitDefine.Size = new System.Drawing.Size(150, 201);
			this.pnlUnitDefine.TabIndex = 0;
			// 
			// btnProductCode
			// 
			this.btnProductCode.AccessibleDescription = "find";
			this.btnProductCode.AccessibleName = "find";
			this.btnProductCode.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnProductCode.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnProductCode.Location = new System.Drawing.Point(112, 96);
			this.btnProductCode.Name = "btnProductCode";
			this.btnProductCode.Size = new System.Drawing.Size(24, 20);
			this.btnProductCode.TabIndex = 6;
			this.btnProductCode.Text = "find";
			this.ttProduct.SetToolTip(this.btnProductCode, "Click to select a blood product code");
			this.btnProductCode.Click += new System.EventHandler(this.btnProductCode_Click_1);
			// 
			// btnFDARegNo
			// 
			this.btnFDARegNo.AccessibleDescription = "find";
			this.btnFDARegNo.AccessibleName = "find";
			this.btnFDARegNo.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnFDARegNo.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnFDARegNo.Location = new System.Drawing.Point(112, 16);
			this.btnFDARegNo.Name = "btnFDARegNo";
			this.btnFDARegNo.Size = new System.Drawing.Size(24, 20);
			this.btnFDARegNo.TabIndex = 2;
			this.btnFDARegNo.Text = "find";
			this.ttProduct.SetToolTip(this.btnFDARegNo, "Click to select an FDA Registration Number");
			this.btnFDARegNo.Click += new System.EventHandler(this.btnFDARegNo_Click_1);
			// 
			// lblFDAReg
			// 
			this.lblFDAReg.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblFDAReg.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblFDAReg.Location = new System.Drawing.Point(20, 0);
			this.lblFDAReg.Name = "lblFDAReg";
			this.lblFDAReg.Size = new System.Drawing.Size(117, 16);
			this.lblFDAReg.TabIndex = 0;
			this.lblFDAReg.Text = "FDA Registration #*";
			// 
			// lblProduct
			// 
			this.lblProduct.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblProduct.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblProduct.Location = new System.Drawing.Point(20, 80);
			this.lblProduct.Name = "lblProduct";
			this.lblProduct.Size = new System.Drawing.Size(117, 16);
			this.lblProduct.TabIndex = 6;
			this.lblProduct.Text = "Product Code*";
			// 
			// pictureBox5
			// 
			this.pictureBox5.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pictureBox5.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox5.Image")));
			this.pictureBox5.Location = new System.Drawing.Point(0, 96);
			this.pictureBox5.Name = "pictureBox5";
			this.pictureBox5.Size = new System.Drawing.Size(20, 20);
			this.pictureBox5.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox5.TabIndex = 45;
			this.pictureBox5.TabStop = false;
			// 
			// txtProduct
			// 
			this.txtProduct.AccessibleDescription = "Product Code";
			this.txtProduct.AccessibleName = "Product Code";
			this.txtProduct.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProduct.Barcode = false;
			this.txtProduct.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtProduct.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtProduct.Location = new System.Drawing.Point(20, 96);
			this.txtProduct.MaxLength = 10;
			this.txtProduct.Name = "txtProduct";
			this.txtProduct.RecursionGuard = false;
			this.txtProduct.Size = new System.Drawing.Size(92, 20);
			this.txtProduct.TabIndex = 5;
			this.txtProduct.Text = "";
			this.ttProduct.SetToolTip(this.txtProduct, "Enter product code");
			this.txtProduct.TextChanged += new System.EventHandler(this.txtProduct_TextChanged);
			this.txtProduct.Leave += new System.EventHandler(this.txtProduct_Leave_1);
			// 
			// pictureBox2
			// 
			this.pictureBox2.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(0, 16);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(20, 20);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 42;
			this.pictureBox2.TabStop = false;
			// 
			// txtFDAReg
			// 
			this.txtFDAReg.AccessibleDescription = "F D A Registration Number";
			this.txtFDAReg.AccessibleName = "F D A Registration Number";
			this.txtFDAReg.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFDAReg.Barcode = false;
			this.txtFDAReg.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtFDAReg.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFDAReg.Location = new System.Drawing.Point(20, 16);
			this.txtFDAReg.MaxLength = 10;
			this.txtFDAReg.Name = "txtFDAReg";
			this.txtFDAReg.Size = new System.Drawing.Size(92, 20);
			this.txtFDAReg.TabIndex = 1;
			this.txtFDAReg.Text = "";
			this.ttProduct.SetToolTip(this.txtFDAReg, "Enter FDA registration number");
			this.txtFDAReg.Leave += new System.EventHandler(this.txtFDAReg_Leave);
			this.txtFDAReg.TextChanged += new System.EventHandler(this.txtFDAReg_TextChanged);
			// 
			// lblSpaceHolder
			// 
			this.lblSpaceHolder.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblSpaceHolder.Location = new System.Drawing.Point(105, 96);
			this.lblSpaceHolder.Name = "lblSpaceHolder";
			this.lblSpaceHolder.Size = new System.Drawing.Size(16, 24);
			this.lblSpaceHolder.TabIndex = 8;
			// 
			// txtCheckCharacter
			// 
			this.txtCheckCharacter.AccessibleDescription = "Check Character";
			this.txtCheckCharacter.AccessibleName = "Check Character";
			this.txtCheckCharacter.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtCheckCharacter.Location = new System.Drawing.Point(116, 56);
			this.txtCheckCharacter.MaxLength = 1;
			this.txtCheckCharacter.Name = "txtCheckCharacter";
			this.txtCheckCharacter.ReadOnly = true;
			this.txtCheckCharacter.Size = new System.Drawing.Size(16, 20);
			this.txtCheckCharacter.TabIndex = 4;
			this.txtCheckCharacter.Text = "";
			this.ttProduct.SetToolTip(this.txtCheckCharacter, "Enter a check character");
			this.txtCheckCharacter.TextChanged += new System.EventHandler(this.txtCheckCharacter_Leave);
			this.txtCheckCharacter.Leave += new System.EventHandler(this.txtCheckCharacter_Leave);
			// 
			// pictureBox6
			// 
			this.pictureBox6.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox6.Image")));
			this.pictureBox6.Location = new System.Drawing.Point(0, 176);
			this.pictureBox6.Name = "pictureBox6";
			this.pictureBox6.Size = new System.Drawing.Size(20, 20);
			this.pictureBox6.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox6.TabIndex = 34;
			this.pictureBox6.TabStop = false;
			// 
			// pictureBox4
			// 
			this.pictureBox4.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox4.Image")));
			this.pictureBox4.Location = new System.Drawing.Point(0, 136);
			this.pictureBox4.Name = "pictureBox4";
			this.pictureBox4.Size = new System.Drawing.Size(20, 20);
			this.pictureBox4.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox4.TabIndex = 32;
			this.pictureBox4.TabStop = false;
			// 
			// pictureBox3
			// 
			this.pictureBox3.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox3.Image")));
			this.pictureBox3.Location = new System.Drawing.Point(0, 56);
			this.pictureBox3.Name = "pictureBox3";
			this.pictureBox3.Size = new System.Drawing.Size(20, 20);
			this.pictureBox3.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox3.TabIndex = 31;
			this.pictureBox3.TabStop = false;
			// 
			// cmbABORh
			// 
			this.cmbABORh.AccessibleDescription = "A B O R h";
			this.cmbABORh.AccessibleName = "A B O R h";
			this.cmbABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbABORh.Barcode = false;
			this.cmbABORh.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.cmbABORh.DonationTypeId = -1;
			this.cmbABORh.Enabled = false;
			this.cmbABORh.Interval = 1;
			this.cmbABORh.Location = new System.Drawing.Point(20, 136);
			this.cmbABORh.Name = "cmbABORh";
			this.cmbABORh.Size = new System.Drawing.Size(114, 22);
			this.cmbABORh.TabIndex = 7;
			this.ttProduct.SetToolTip(this.cmbABORh, "Choose ABO/Rh");
			this.cmbABORh.AboRHNotFound += new System.EventHandler(this.cmbABORh_AboRHNotFound);
			this.cmbABORh.TextChanged += new System.EventHandler(this.cmbABORh_TextChanged);
			this.cmbABORh.Leave += new System.EventHandler(this.cmbABORh_Leave);
			this.cmbABORh.AboRHFound += new System.EventHandler(this.cmbABORh_AboRHFound);
			// 
			// dtpExpiration
			// 
			this.dtpExpiration.AccessibleDescription = "Expiration Date";
			this.dtpExpiration.AccessibleName = "Expiration Date";
			this.dtpExpiration.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpExpiration.Barcode = false;
			this.dtpExpiration.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.dtpExpiration.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpExpiration.IsbtBarcodeDate = "";
			this.dtpExpiration.Location = new System.Drawing.Point(20, 176);
			this.dtpExpiration.MaxDate = new System.DateTime(9998, 12, 31, 0, 0, 0, 0);
			this.dtpExpiration.MinDate = new System.DateTime(1753, 1, 1, 0, 0, 0, 0);
			this.dtpExpiration.Name = "dtpExpiration";
			this.dtpExpiration.Size = new System.Drawing.Size(114, 20);
			this.dtpExpiration.TabIndex = 8;
			this.ttProduct.SetToolTip(this.dtpExpiration, "Enter expiration date");
			this.dtpExpiration.Value = new System.DateTime(2003, 1, 7, 0, 0, 0, 0);
			this.dtpExpiration.Leave += new System.EventHandler(this.dtpExpiration_Leave);
			// 
			// txtUnitID
			// 
			this.txtUnitID.AccessibleDescription = "Unit I D";
			this.txtUnitID.AccessibleName = "Unit I D";
			this.txtUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitID.Barcode = false;
			this.txtUnitID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtUnitID.Location = new System.Drawing.Point(20, 56);
			this.txtUnitID.MaxLength = 15;
			this.txtUnitID.Name = "txtUnitID";
			this.txtUnitID.Size = new System.Drawing.Size(96, 20);
			this.txtUnitID.TabIndex = 3;
			this.txtUnitID.Text = "";
			this.ttProduct.SetToolTip(this.txtUnitID, "Enter Unit ID");
			this.txtUnitID.TextChanged += new System.EventHandler(this.txtUnitID_TextChanged);
			this.txtUnitID.Leave += new System.EventHandler(this.txtUnitID_Leave);
			// 
			// lblExpiration
			// 
			this.lblExpiration.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblExpiration.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblExpiration.Location = new System.Drawing.Point(20, 160);
			this.lblExpiration.Name = "lblExpiration";
			this.lblExpiration.Size = new System.Drawing.Size(117, 16);
			this.lblExpiration.TabIndex = 12;
			this.lblExpiration.Text = "Expiration Date*";
			// 
			// lblUnitID
			// 
			this.lblUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblUnitID.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblUnitID.Location = new System.Drawing.Point(20, 40);
			this.lblUnitID.Name = "lblUnitID";
			this.lblUnitID.Size = new System.Drawing.Size(117, 16);
			this.lblUnitID.TabIndex = 3;
			this.lblUnitID.Text = "Unit ID*";
			// 
			// lblABORh
			// 
			this.lblABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblABORh.Location = new System.Drawing.Point(20, 120);
			this.lblABORh.Name = "lblABORh";
			this.lblABORh.Size = new System.Drawing.Size(117, 16);
			this.lblABORh.TabIndex = 10;
			this.lblABORh.Text = "ABO/Rh*";
			// 
			// invoiceDisplayPanel1
			// 
			this.invoiceDisplayPanel1.AccessibleDescription = "Invoice Details";
			this.invoiceDisplayPanel1.AccessibleName = "Invoice Details";
			this.invoiceDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.invoiceDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.invoiceDisplayPanel1.IncomingShipment = false;
			this.invoiceDisplayPanel1.Invoice = null;
			this.invoiceDisplayPanel1.Location = new System.Drawing.Point(4, 0);
			this.invoiceDisplayPanel1.Name = "invoiceDisplayPanel1";
			this.invoiceDisplayPanel1.Shipment = null;
			this.invoiceDisplayPanel1.Size = new System.Drawing.Size(736, 40);
			this.invoiceDisplayPanel1.TabIndex = 0;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(662, 498);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 19;
			this.btnCancel.Text = "&Close";
			this.ttProduct.SetToolTip(this.btnCancel, "Click to return");
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = -1;
			this.menuItem1.Text = "Clear All Antigens";
			this.menuItem1.Click += new System.EventHandler(this.btnClearAntigens_Click);
			// 
			// FrmProcessShipmentIn
			// 
			this.AcceptButton = this.btnAdd;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(742, 523);
			this.Controls.Add(this.pnlAddUnit);
			this.Controls.Add(this.btnCancel);
			this.hlpHelp.SetHelpKeyword(this, "");
			this.hlphelpChm.SetHelpKeyword(this, "Incoming_Shipment.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(728, 520);
			this.Name = "FrmProcessShipmentIn";
			this.RequiredFieldsLabel = true;
			this.hlpHelp.SetShowHelp(this, false);
			this.hlphelpChm.SetShowHelp(this, true);
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "VBECS - Process Incoming Shipment";
			this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FrmProcessShipmentIn_Closing);
			this.Load += new System.EventHandler(this.FrmProcessShipmentIn_Load);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmProcessShipmentIn_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.pnlAddUnit, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.pnlAddUnit.ResumeLayout(false);
			this.pnlUnitSelect.ResumeLayout(false);
			this.pnlShipmentUnits.ResumeLayout(false);
			this.grpShipmentUnits.ResumeLayout(false);
			this.pnlUnit.ResumeLayout(false);
			this.grpAddUnit.ResumeLayout(false);
			this.pnlDonation.ResumeLayout(false);
			this.grpSpecialTestingCost.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updSpecialTestingCost)).EndInit();
			this.grpRestrictedFor.ResumeLayout(false);
			this.pnlRestricted.ResumeLayout(false);
			this.grpTypeExtended.ResumeLayout(false);
			this.pnlStatus.ResumeLayout(false);
			this.pnlSpecialTesting.ResumeLayout(false);
			this.pnlUnitDefine.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		///     HandleCheckCharacterLeave handles the leave event of the check character.
		/// </summary>
		/// 
		/// <returns>
		///     A void value...
		/// </returns>
		private void HandleCheckCharacterLeave()
		{
			if(this.txtUnitID.ReadOnly == true && this.txtCheckCharacter.Text.Trim().Length < 0) return;

			if (this.txtCheckCharacter.Text.Trim().Length == 0 )
			{
				if(this._bloodUnit != null)
				{
					this._bloodUnit.CheckCharacter = String.Empty;
				}
				return;
			}
			this.IsDirty = true;
			string checkChar = this.txtCheckCharacter.Text.Substring(0,1);
			
			if (!checkChar.Equals(GenerateCheckNumber(txtUnitID.Text)))
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.txtCheckCharacter, Common.StrRes.ValidMsg.UC001.CheckCharacterWrong().ResString);
			}
			else
			{
				if(this._bloodUnit != null)
				{
					this._bloodUnit.CheckCharacter = this.txtCheckCharacter.Text;
				}
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.txtCheckCharacter, string.Empty);
				this.txtCheckCharacter.ReadOnly = true;
				this.txtCheckCharacter.TabStop = false;
			}
		}
		/// <summary>
		///     txtCheckCharacter_Leave makes a call to the HandleCheckCharacterLeave
		/// </summary>
		/// <returns>
		///     A void value...
		/// </returns>
		private void txtCheckCharacter_Leave(object sender, System.EventArgs e)
		{
			HandleCheckCharacterLeave();
		}

		/// <summary>
		/// Event handler for Add button.  Sets Add button to IsValid flag on Blood Bag.
		/// </summary>
		private void CheckValid(object sender, System.EventArgs e)
		{
			//BR 1.10
			if (this.errError.GetError(this.txtUnitID).Trim() != String.Empty || this.errError.GetError(this.btnProductCode).Trim() != string.Empty)
			{
				btnAdd.EnabledButton = false;
				return;
			}

			if ( _bloodUnit == null || _bloodUnit.BloodUnitMedia.AboRh == null || _bloodUnit.BloodUnitMedia == null || _bloodUnit.DonationType == null ) 
			{
				btnAdd.EnabledButton = false;
			}
			else
			{
				bool bValid = _bloodUnit.IsValid && _bloodUnit.BloodUnitFinance.IsValid && _bloodUnit.BloodUnitMedia.AboRh.IsValid && _bloodUnit.BloodUnitMedia.IsValid && _bloodUnit.DonationType.IsValid;
				btnAdd.EnabledButton = bValid;
				bool requiresVal = false;
				if(this.Codabar)
				{
					//CR 3171
					requiresVal = (_bloodUnit.UnitFdaRegistrationNumber.Length >= 7  && _bloodUnit.ProductCode.Length >= 4 && _bloodUnit.BloodUnitMedia.AboRh.IsValid && this._bloodUnit.BloodUnitMedia.UnitExpirationDate != System.DateTime.MinValue && this.dtpExpiration.Value == this._bloodUnit.BloodUnitMedia.UnitExpirationDate);
				}
				else
				{
					requiresVal = (_bloodUnit.ProductCode.Length >= 4 && _bloodUnit.BloodUnitMedia.AboRh.IsValid && this._bloodUnit.BloodUnitMedia.UnitExpirationDate != System.DateTime.MinValue && this.dtpExpiration.Value == this._bloodUnit.BloodUnitMedia.UnitExpirationDate);
				}
				if(requiresVal)
				{
					if(_retValVerifyExistingUnit ==false)
					{
						_retValVerifyExistingUnit = this.ValidateIfExistingUnit(false);
					}
					if(this._reenteredUnit)
					{
						this.cmbType.Enabled = false;
						this.cmbTestingStatus.Enabled = false;
						//If Transfusion only we have to enable the select patient and require it.
						if(!ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
						{
							//Break the rule
							if(this.txtPatient.Text.Trim().Length == 0)
							{
								this._bloodUnit.DirectedPatient = null;
								this.btnSelectPatient.Enabled = true;
								btnAdd.SetToolTip("A patient must be chosen");		
							}
						}
						else
						{
							this.btnSelectPatient.Enabled = false;
							btnAdd.EnabledButton = _bloodUnit.IsValid && _bloodUnit.BloodUnitFinance.IsValid && _bloodUnit.BloodUnitMedia.AboRh.IsValid && _bloodUnit.BloodUnitMedia.IsValid && _bloodUnit.DonationType.IsValid;;
						}
						this.updSpecialTestingCost.Enabled = false;
						this.specialTesting1.Enabled = false;
										
					}
					else if(this._retValVerifyExistingUnit)
					{
						this.Clear();	
						this.Clear();
						this.btnAdd.EnabledButton = false;
						if(this.Codabar == false || this.txtFDAReg.Text.Length > 0)
						{
							this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC001.NoUnitInstance().ResString);
						}
						if(this.Codabar)
						{
							this.txtFDAReg.Focus();
						}
						else
						{
							this.txtUnitID.Focus();
						}
						
					}
				}
			}
		}

		/// <summary>
		/// Event handler for Clear button.  Sets Clear button to IsDirty flag on Blood Bag.
		/// </summary>
		private void CheckDirty(object sender, System.EventArgs e)
		{
			btnClear.Enabled = true;
		}

		
		/// <summary>
		///     GetDonationTypeCode finds the cdoe associated with the donation type in the list
		/// </summary>
		/// <param name="sSearchText" type="string">
		///     <para>
		///         
		///     </para>
		/// </param>
		/// <returns>
		///     A char value...
		/// </returns>
		private char GetDonationTypeCode(string sSearchText)
		{
			foreach(Object obj in this._alDonationTypeList)
			{
				if(((BOL.DonationType)(obj)).DonationTypeText == sSearchText)
				{
					return ((BOL.DonationType)(obj)).DonationTypeCode;
				}
			}
			return Char.MinValue;
		}

		
		/// <summary>
		///     GetDonationTypeText gets the text of the donation typ associated with the code.
		/// </summary>
		/// <param name="donationTypeCode" type="char">
		///     <para>
		///         
		///     </para>
		/// </param>
		/// <returns>
		///     A string value...
		/// </returns>
		private string GetDonationTypeText(char donationTypeCode)
		{
			foreach(Object obj in this._alDonationTypeList)
			{
				if(((BOL.DonationType)(obj)).DonationTypeCode == donationTypeCode)
				{
					return ((BOL.DonationType)(obj)).DonationTypeText;
				}
			}
			return String.Empty;
		}
		
		private int GetTestingStatusID(string testingStatusText)
		{	
			int nRetVal = System.Int32.MinValue;		
			foreach(string sTestingStatus in this._alTestingStatusList)
			{
				int nComma = sTestingStatus.IndexOf(",");
				string sID = sTestingStatus.Substring(0, nComma); 
				string sText = sTestingStatus.Substring(nComma + 1); 
				if(sText == testingStatusText)
				{
					nRetVal = System.Convert.ToInt32(sID);
					return nRetVal;
				}
			}
			return nRetVal;
		}

		private string GetTestingStatusText(int testingStatusID)
		{
			string sText = String.Empty;
			foreach(string sTestingStatus in this._alTestingStatusList)
			{
				int nComma = sTestingStatus.IndexOf(",");
				string sID = sTestingStatus.Substring(0, nComma); 
				sText = sTestingStatus.Substring(nComma + 1); 
				if(System.Convert.ToInt32(sID) == testingStatusID)
				{
					return sText;
				}
			}	
			return sText;
		}
		/// <summary>
		/// Handles the Load Event of the form
		/// </summary>	
		private void FrmProcessShipmentIn_Load(object sender, System.EventArgs e)
		{
			okButtonToolTipText = Common.StrRes.Tooltips.UC001.MustbeUnitinIncomingShipmentTable().ResString;
			this.IsDirty = false;
			if (codabar) 
			{
				this.txtFDAReg.Focus();
			}
			else
			{
				this.txtUnitID.Focus();
			}
		}

		/// <summary>
		/// Clears all information about the current unit
		/// </summary>	
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this.IsDirty = false;
			//Clear must be called twice
			Clear();
			Clear();
			if(this.Codabar)
			{
				this.txtFDAReg.Focus();
			}
			else
			{
				this.txtUnitID.Focus();
			}
		}
		private void Clear()
		{
			this.SetUpFormNewBloodUnit();
			this.bloodUnitLabel1.ClearBloodUnitLabel();
			// **** 508 Compliance ***
			this.errError.SetVbecsError(this.btnFDARegNo,string.Empty);
			this.errError.SetVbecsError(this.btnProductCode, string.Empty);
			this.errError.SetVbecsError(this.cmbABORh, string.Empty);
			this.errError.SetVbecsError(this.dtpExpiration, string.Empty);
			this.errError.SetVbecsError(this.cmbType, string.Empty);
			this.errError.SetVbecsError(this.txtPatient, string.Empty);
			this.errError.SetVbecsError(this.cmbTestingStatus, string.Empty);
			this.errError.SetVbecsError(this.updSpecialTestingCost, string.Empty);
			this.errError.SetVbecsError(this.txtCheckCharacter, string.Empty);
			this.errError.SetVbecsError(this.txtUnitID, string.Empty);

			this.txtFDAReg.Barcode = false;
			this.txtProduct.Barcode = false;
			this.txtUnitID.Barcode = false;
			this.txtCheckCharacter.ReadOnly = true;
			this.txtCheckCharacter.TabStop = false;
			this.cmbABORh.Barcode = false;
			this.cmbABORh.Enabled = false;
			this.dtpExpiration.Barcode = false;
			this.btnSelectPatient.Enabled = false;

			if (codabar)
			{
				EnableDisable(false);
				this.txtFDAReg.Focus();
			}
			else
			{
				this.cmbType.Enabled = false;
				this.txtUnitID.ReadOnly = false;
				this.txtProduct.ReadOnly = false;
				this.btnProductCode.Enabled = true;
			}
			this.specialTesting1.AntigensEnabled = false;
			this.specialTesting1.SickleCellEnabled = false;
			this.specialTesting1.CmvEnabled = false;
			
		
			
			this.cmbTestingStatus.Enabled = false;
			this._bloodUnit = null;
			this._bloodProduct = null;
			this._localSupplier = null;
			// array list to hold antigen modifications
			this._alBloodUnitAntigens = new System.Collections.ArrayList();
			this.specialTestingHash = new Hashtable();
			
			this._reenteredUnit = false;
			this._retValVerifyExistingUnit = false;
			this._transferredOutandInConfirmed = false;
			this.IsDirty = false;
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void HandlecmbTypeChange()
		{
			if(this._bloodUnit == null) return;
			if ((cmbType.Text.Length > 0) && (cmbType.SelectedIndex > -1) && _bloodUnit != null)
			{
				this.IsDirty = true;
				try
				{
					char donationTypeCode = this.GetDonationTypeCode(this.cmbType.Text);
					
					if(donationTypeCode > char.MinValue)
					{
						this._bloodUnit.DonationType.DonationTypeCode = donationTypeCode;
						if(this._bloodUnit == null)
						{
							this.Clear();
							return;
						}
						
					
						switch (this._bloodUnit.DonationType.DirectedType)
						{
								//BR 1.34, 1.35, 1.37
								//Autologous
							case "A":
								this.cmbTestingStatus.Enabled = true;
								if(this.cmbTestingStatus.Text.Trim().Length >0)
								{
									this.HandlecmbTestingStatusChange();
									this.bloodUnitLabel1.Refresh();
								}
								else
								{
									this._bloodUnit.BloodUnitMedia.TestingStatusId = System.Int32.MinValue;
								}
								break;
								//Directed
							case "D":
								// set this to null if changed to something else from autologous
								this.cmbTestingStatus.Text = String.Empty;
								this.cmbTestingStatus.SelectedIndex = 0;
								this._bloodUnit.BloodUnitMedia.TestingStatusId = 0;
								this.cmbTestingStatus.Enabled = false;
								break;
								//Homologous (Allogeneic)
							default:
								// set this to null if changed to something else from autologous
								this.cmbTestingStatus.Text = String.Empty;
								this.cmbTestingStatus.SelectedIndex = 0;
								this._bloodUnit.BloodUnitMedia.TestingStatusId = 0;
								//								//This is just to dismiss the broken rule
								this._bloodUnit.DirectedPatient = new BOL.Patient();
								this.cmbTestingStatus.Enabled = false;
								this.txtPatient.Text = String.Empty;
								break;
						}
						if(BOL.BloodUnit.IsDirected(donationTypeCode) || (BOL.BloodUnit.IsAutologous(donationTypeCode)))
						{
							this.btnSelectPatient.Enabled = true;
						}
						else
						{
							//If this is a transfusion only site we should not disable the select patient button.
							if(!ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
							{
								this.btnSelectPatient.Enabled = false;
							}
						}
						if(!this.Codabar && this._bloodUnit != null && this._bloodUnit.FullProductCode.Length > 5)
						{
							this.txtProduct.Text = this._bloodUnit.FullProductCode;
						}
						// **** 508 Compliance ***
						errError.SetVbecsError(cmbType, string.Empty);
					}

					if (cmbType.Text == string.Empty)
					{
						this._bloodUnit.DonationType.DonationTypeCode = Common.Utility.GetDonationTypeCodeCharFromEnum(Common.DonationType.Unknown);
						// **** 508 Compliance ***
						errError.SetVbecsError(cmbType, string.Empty);
					}
				}
				catch (BOL.BusinessObjectException ex)
				{
					// **** 508 Compliance ***
					errError.SetVbecsError(cmbType, ex.Message);
				}
				finally
				{
					if(this._bloodUnit != null)
					{
						RestrictUnitToPatient();
					}
				}
			}
			else
			{
				this._bloodUnit.DonationType.DonationTypeCode = Common.Utility.GetDonationTypeCodeCharFromEnum(Common.DonationType.Unknown);
				this.cmbTestingStatus.Text = String.Empty;
				this.cmbTestingStatus.SelectedIndex = 0;
				this._bloodUnit.BloodUnitMedia.TestingStatusId = 0;
				if(!ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
				{
					//This is just to dismiss the broken rule
					this._bloodUnit.DirectedPatient = new BOL.Patient();
					this.btnSelectPatient.Enabled = false;
					this.txtPatient.Text = String.Empty;
				}
				this.cmbTestingStatus.Enabled = false;
				// **** 508 Compliance ***
				errError.SetVbecsError(cmbType, string.Empty);
			}
		}

		private bool RestrictUnitToPatient()
		{
			if(this._bloodUnit == null) return false;
			bool bRestricted = (BOL.BloodUnit.IsAutologous(this._bloodUnit.DonationType.DonationTypeCode) ||
					BOL.BloodUnit.IsDirected(this._bloodUnit.DonationType.DonationTypeCode));
			//if the facility is transfusion only or the unit is autologous or directed
			if (!ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator || bRestricted)
			{
				this.btnSelectPatient.Enabled = true;
				if(this.txtPatient.Text.Trim().Length == 0)
				{
					//Break the rule
					this._bloodUnit.DirectedPatient = null;
				}
			}
			else
			{
				this.btnSelectPatient.Enabled = false;
				this.txtPatient.Text = string.Empty;
				//Break the rule
				this._bloodUnit.DirectedPatient = new BOL.Patient();;
			}
			if(!this._bloodUnit.IsValid)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		/// <summary>
		/// Controls the panels that are enabled/disabled based on Donation Type
		/// </summary>
		private void cmbType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			if(this._retValVerifyExistingUnit == true) return;
			if(this._bloodUnit != null)
			{
				HandlecmbTypeChange();
				this.bloodUnitLabel1.Refresh();
			}

		}

		/// <summary>
		/// Handle the scanner lead character
		/// </summary>	
		private void cmbABORh_TextChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			if (cmbABORh.Text == "~") 
			{
				cmbABORh.Text = string.Empty;
			}
			else if(cmbABORh.Text.Length == 0)
			{
				if(this._bloodUnit != null)
				{
					this._bloodUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.NA;
				}
			}

		}

		/// <summary>
		/// Calls the ClearAntigens Routine
		/// </summary>	
		private void btnClearAntigens_Click(object sender, System.EventArgs e)
		{
			specialTesting1.ResetSpecialTesting();
		}
		private void ResetFocus()
		{
			if(this.codabar)
			{
				this.txtFDAReg.Focus();
			}
			else
			{
				this.txtUnitID.Focus();
			}
		}
		

		private bool ValidateIfExistingUnit(bool bselectButtonClick)
		{
			bool bloodUnitExists = false;
			System.Guid bloodUnitGUID = System.Guid.Empty;
			//BR 1.40 check if unit exists in inventory today
			if(this._bloodUnit.EyeReadableUnitId.Length > 0)
			{
				bloodUnitExists = BOL.BloodUnit.BloodUnitExists(this._bloodUnit.EyeReadableUnitId, this._bloodUnit.BloodProductGuid, this._bloodUnit.FullProductCode,  ref bloodUnitGUID);
			}
			else
			{
				bloodUnitExists = BOL.BloodUnit.BloodUnitExists(this._bloodUnit.LabelUnitId, this._bloodUnit.BloodProductGuid, this._bloodUnit.FullProductCode,  ref bloodUnitGUID);
			}
			if(bloodUnitExists)
			{
				//Set up blood unit object
				BOL.BloodUnit existingBloodUnit = new BOL.BloodUnit(bloodUnitGUID);
			
				System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

				// BloodUnit will not be added to the list
				if (existingBloodUnit.BloodUnitMedia.UnitExpirationDate.Date < currentDate.Date)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnitExistsinDatabase());
					this._bloodUnit = null;
					ResetFocus();
					return bloodUnitExists;
				}
				else
				{
					// get the shipment type
					string shipmentType = BOL.IncomingShipment.GetShipmentTypeByUnit(existingBloodUnit.BloodUnitGuid);
										
			
					Common.ShipmentType shipmentTypeCommon;
				
					switch(shipmentType)
					{
						case ("1"):
						{
							shipmentTypeCommon = Common.ShipmentType.ReturnToSupplier;
							break;
						}
						case ("2"):
						{
							shipmentTypeCommon = Common.ShipmentType.SendToOtherVA;
							break;
						}
						case ("3"):
						{
							shipmentTypeCommon = Common.ShipmentType.SendToOtherFacility;
							break;
						}
						default:
						{
							shipmentTypeCommon = Common.ShipmentType.Unknown;
							break;
						}
					}
					existingBloodUnit.IncomingShipment.ShipmentType = shipmentTypeCommon;
					
												
					if (existingBloodUnit.IncomingShipment.ShipmentType == Common.ShipmentType.Unknown)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnitExistsinDatabase());
						return bloodUnitExists;
					}
					else if(!bselectButtonClick & this._transferredOutandInConfirmed == false)
					{
						DialogResult result;
						if(ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
						{
							result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC001.BR140Full());
						}
						else
						{
							result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC001.BR140Trans());
						}
						if (result == DialogResult.Yes)
						{
							if (this._bloodUnit.BloodUnitMedia.AboRh.AboRHText.Equals(existingBloodUnit.BloodUnitMedia.AboRh.AboRHText) && this._bloodUnit.BloodUnitMedia.UnitExpirationDate.Date == existingBloodUnit.BloodUnitMedia.UnitExpirationDate.Date)
							{
								this._transferredOutandInConfirmed = true;
								this._bloodUnit = existingBloodUnit;
								this._reenteredUnit = true;

								
							
								if (cmbTestingStatus.Text != string.Empty)
								{
									this._bloodUnit.BloodUnitMedia.TestingStatusId = this.GetTestingStatusID(this.cmbTestingStatus.Text);
								}
								else
								{
									this._bloodUnit.BloodUnitMedia.TestingStatusId = 0;
								}
								
							}
							else
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.ADORHOrExpirationDatesDoNotMatch());
							}
							return bloodUnitExists;
						}
						else
						{
							this.Clear();	
							this.Clear();
							this.btnAdd.EnabledButton = false;
							if(this.Codabar == false || this.txtFDAReg.Text.Length > 0)
							{
								this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC001.NoUnitInstance().ResString);
							}
							if(this.Codabar)
							{
								this.txtFDAReg.Focus();
							}
							else
							{
								this.txtUnitID.Focus();
							}
							return bloodUnitExists;
						}
					}
				}
			}
			//Codabar reuses unit id numbers, we have to check if this unit ever existed and has since been modified
				//this checks the blood unit shipment table for all data ever entered into the system. - Nevermind they 
				//changed there minds This applies to both CodaBar and IsBT
		
			//BR 1.40
			if(this._bloodUnit.EyeReadableUnitId.Length > 0)
			{
				bloodUnitExists = BOL.BloodUnit.IncomingShipmentBloodUnitExists(this._bloodUnit.EyeReadableUnitId, this._bloodUnit.BloodProductGuid, this._bloodUnit.FullProductCode,  ref bloodUnitGUID);
			}
			else
			{
				bloodUnitExists = BOL.BloodUnit.IncomingShipmentBloodUnitExists(this._bloodUnit.LabelUnitId, this._bloodUnit.BloodProductGuid, this._bloodUnit.FullProductCode,  ref bloodUnitGUID);
			}
			if(bloodUnitExists && !_transferredOutandInConfirmed)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnitExistsinDatabase());
			}
						
			return bloodUnitExists;
		}

		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			string[] mySubItems = new string[7];
			
			if(this._bloodUnit != null)
			{
				HandleSpecialTestingCostLeave();
				

				string specialTests = this.specialTesting1.GetSpecialTestsString();

				if (_bloodUnit.BloodUnitGuid == System.Guid.Empty) 
				{
					_bloodUnit.BloodUnitGuid = System.Guid.NewGuid();
				}
				if(!this._reenteredUnit)
				{
					System.Collections.ArrayList alAntigens = this.specialTesting1.AntigensList;
	
			
					modificationsHash = new Hashtable();
                   

				
					this._alBloodUnitAntigens = new ArrayList();
					foreach (Object obj in alAntigens)
					{
						BOL.BloodUnitAntigen bloodUnitAntigen = (BOL.BloodUnitAntigen) obj;
						int antigenTypeID = bloodUnitAntigen.AntigenTypeId;
						bool positive = bloodUnitAntigen.Positive;
				
						BOL.BloodUnitAntigen newBloodUnitAntigen = new BOL.BloodUnitAntigen();
				
						newBloodUnitAntigen.BloodUnitGuid= this._bloodUnit.BloodUnitGuid;
						newBloodUnitAntigen.AntigenTypeId = antigenTypeID;
						newBloodUnitAntigen.Positive = positive;
						newBloodUnitAntigen.RecordStatusCode = bloodUnitAntigen.RecordStatusCode;
						newBloodUnitAntigen.LastUpdateUser = ThisUser.UserNTLoginID;
						newBloodUnitAntigen.IsNew = bloodUnitAntigen.IsNew;
						string indicator;
						if (positive) indicator = "P";
						else indicator = "N";
			
						if (bloodUnitAntigen.RecordStatusCode == Common.RecordStatusCode.Active)
						{
							if(!this._alBloodUnitAntigens.Contains(newBloodUnitAntigen))
							{
								this._alBloodUnitAntigens.Add(newBloodUnitAntigen);
							}
							if (!modificationsHash.ContainsKey(antigenTypeID.ToString().Trim() + indicator))
							{
								modificationsHash.Add(antigenTypeID.ToString().Trim() + indicator, true);
							}
						}
						else
						{
							foreach(Object antigen in this._alBloodUnitAntigens)
							{
								BOL.BloodUnitAntigen currBloodUnitAntigen = (BOL.BloodUnitAntigen) antigen;
								if(currBloodUnitAntigen.BloodUnitGuid == _bloodUnit.BloodUnitGuid &&
									currBloodUnitAntigen.AntigenTypeId == antigenTypeID &&
									currBloodUnitAntigen.Positive == positive)
								{
									this._alBloodUnitAntigens.Remove(currBloodUnitAntigen);
									return;
								}
							}
							if (modificationsHash.ContainsKey(antigenTypeID.ToString().Trim() + indicator))
							{
								modificationsHash.Remove(antigenTypeID.ToString().Trim() + indicator);
							}
						}
					}
					// add the other tests from specialTesting
		
					if(!this.specialTesting1.SickleCellNegative)
					{
						modificationsHash.Add(_sickleCell.ToString(),null);
					}
					else
					{
						modificationsHash.Add(_sickleCell.ToString(),!specialTesting1.SickleCellNegative);
					}
					if(!this.specialTesting1.CmvNegative)
					{
						modificationsHash.Add(_cmvNeg.ToString(), null);
					}
                    else 
                    {
						modificationsHash.Add(_cmvNeg.ToString(), !specialTesting1.CmvNegative);
					}
				}
				else
				{
					System.Data.DataTable dtAntigens = BOL.BloodUnitAntigen.GetBloodUnitAntigens(this._bloodUnit.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
					System.Text.StringBuilder sb = new System.Text.StringBuilder();
					
					if(this._bloodUnit.CmvNegative)
					{
						sb.Append("CMV Negative/");
					}
					//Sickle Cell
					if (this._bloodUnit.SickleCellNegative)
					{
						sb.Append("Sickle Cell Negative/");
					}
					modificationsHash = new Hashtable();
                   
					
					foreach (System.Data.DataRow dtRow in dtAntigens.Rows)
					{
						BOL.BloodUnitAntigen bloodUA = new BOL.BloodUnitAntigen(dtRow);

						int antigenTypeID = bloodUA.AntigenTypeId;
						bool positive = bloodUA.Positive;
				
						BOL.BloodUnitAntigen newBloodUnitAntigen = new BOL.BloodUnitAntigen();
				
						newBloodUnitAntigen.BloodUnitGuid= this._bloodUnit.BloodUnitGuid;
						newBloodUnitAntigen.AntigenTypeId = antigenTypeID;
						newBloodUnitAntigen.Positive = positive;
						newBloodUnitAntigen.RecordStatusCode = bloodUA.RecordStatusCode;
						newBloodUnitAntigen.LastUpdateUser = ThisUser.UserNTLoginID;
						newBloodUnitAntigen.IsNew = bloodUA.IsNew;
						string indicator;
						if (positive) indicator = "P";
						else indicator = "N";
			
						if (bloodUA.RecordStatusCode == Common.RecordStatusCode.Active)
						{
							if (!modificationsHash.ContainsKey(antigenTypeID.ToString().Trim() + indicator))
							{
								modificationsHash.Add(antigenTypeID.ToString().Trim() + indicator, true);
							}
							if(positive)
							{
								sb.Append(bloodUA.AntigenName.Trim() + " POS");
							}
							else
							{
								sb.Append(bloodUA.AntigenName.Trim() + " NEG");
							}
							sb.Append("/");
						}
					}
					// add the other tests from specialTesting
					modificationsHash.Add(_sickleCell.ToString(),!this._bloodUnit.SickleCellNegative);
					modificationsHash.Add(_cmvNeg.ToString(), !this._bloodUnit.CmvNegative);
					//Remove last "/"
					if (sb.Length > 0)
					{
						sb.Remove(sb.Length-1,1);
					}

					specialTests = sb.ToString();
				}
				// edits don't need to be added to Hashtable
				if (!specialTestingHash.ContainsKey(_bloodUnit.BloodUnitGuid))
				{
					specialTestingHash.Add(_bloodUnit.BloodUnitGuid, modificationsHash);
				}
				else //CR 3325
				{
				    specialTestingHash[_bloodUnit.BloodUnitGuid] = modificationsHash;
				}
			
				if(_bloodUnit.EyeReadableUnitId.Length > 0)
				{
					string[] subItems = 
					{
						_bloodUnit.EyeReadableUnitId,														
						_bloodUnit.BloodUnitMedia.AboRh.AboRHText,
						_bloodUnit.ProductShortName+", "+_bloodUnit.FullProductCode,
						Common.VBECSDateTime.FormatDateTimeString(_bloodUnit.BloodUnitMedia.UnitExpirationDate),
						_bloodUnit.DonationType.DonationTypeText,
						this._bloodUnit.DirectedPatient.DisplayName,
						specialTests			
					};
					mySubItems = subItems;
				}
				else
				{
					string[] subItems = 
					{
						_bloodUnit.LabelUnitId, 
						_bloodUnit.BloodUnitMedia.AboRh.AboRHText,
						_bloodUnit.ProductShortName+", "+_bloodUnit.FullProductCode,
						Common.VBECSDateTime.FormatDateTimeString(_bloodUnit.BloodUnitMedia.UnitExpirationDate),
						_bloodUnit.DonationType.DonationTypeText,
					    this._bloodUnit.DirectedPatient.DisplayName,
						specialTests			
					};
					mySubItems = subItems;
				}
				
				System.Text.StringBuilder buildBloodUnitList = new StringBuilder();
				int nCtr = 0;
				foreach(string col in mySubItems)
				{
					buildBloodUnitList.Append(col);
					if(nCtr != mySubItems.GetLength(0))
					{
						buildBloodUnitList.Append("~");
					}
				}

				this._listItem = buildBloodUnitList.ToString();					

				if(	this.Save())
				{
					this.AddToListView(mySubItems);
					this.Clear();	
					this.Clear();
					this.btnAdd.EnabledButton = false;
					if(this.Codabar == false || this.txtFDAReg.Text.Length > 0)
					{
						this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC001.NoUnitInstance().ResString);
					}
					if(this.Codabar)
					{
						this.txtFDAReg.Focus();
					}
					else
					{
						this.txtUnitID.Focus();
					}
				}
			}
			
		}
		
		private void AddToListViewAL(ArrayList subItemsList)
		{
			ListViewItem newItem = new ListViewItem();	
			for(int nCtr = 0; nCtr< subItemsList.Count; nCtr++)
			{	
				string [] subItems = (string[])subItemsList[nCtr];
				// Add to UI control
				newItem = new ListViewItem(subItems);
				this.lvShipmentUnits.Items.Add(newItem);
			}

				
			if (this.lvShipmentUnits.Items.Count > 0)
			{
				this.lvShipmentUnits.Items[this.lvShipmentUnits.Items.Count-1].Checked = true;
			}

			controls.VbecsFunction.SetColumnWidths(this.lvShipmentUnits);

			this.SetUpFormNewBloodUnit();

			UnitListChanged();
			if(this._bloodUnit != null)
			{
				this._bloodUnit.IsNew = false;
			}
		}

		private void AddToListView(string [] subItems)
		{
			ListViewItem newItem = new ListViewItem(subItems);
			
			//Needed for populating existing blood units
			if(this._bloodUnit != null)
			{
				if(this._bloodUnit.IsNew)
				{
					_bloodUnit.LastUpdateUser = ThisUser.LastUpdateUser;
					_bloodUnit.RecordStatusCode = Common.RecordStatusCode.Active;
				}
			}
			newItem.Tag = _bloodUnit;
			this.lvShipmentUnits.Items.Add(newItem);
			this.lvShipmentUnits.Items[this.lvShipmentUnits.Items.Count-1].Checked = true;

			controls.VbecsFunction.SetColumnWidths(this.lvShipmentUnits);

			this.SetUpFormNewBloodUnit();

			UnitListChanged();
			this._bloodUnit.IsNew = false;
		}

		private void HandleFDARegLeave()
		{
			try
			{
				if (this.txtFDAReg.Text == string.Empty) return;
				this.IsDirty = true;
				//BR 1.11
				string fdaRegistrationNumber = this.txtFDAReg.Text.Trim().Length == 9 ? this.txtFDAReg.Text.Trim().Substring(1,7) : this.txtFDAReg.Text.Trim();

				this._bloodUnit.UnitFdaRegistrationNumber = fdaRegistrationNumber;
				this.txtFDAReg.Text = this._bloodUnit.UnitFdaRegistrationNumber;
				//I set this read only flag to true cause I am assuming you will not be editing this collection facility
				
				this._bloodUnit.LocalSupplier = new BOL.LocalSupplier(this._bloodUnit.UnitFdaRegistrationNumber,true);
				
				if(this._bloodUnit.LocalSupplier.FDARegistrationNumber.Trim().Length == 0)
				{
					this._bloodUnit.LocalSupplier.FDARegistrationNumber = this._bloodUnit.UnitFdaRegistrationNumber;
				}
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.btnFDARegNo, string.Empty);
				this.bloodUnitLabel1.Refresh();			
			}
			catch (IndexOutOfRangeException)
			{
				BOL.LocalSupplier localSupplier = new BOL.LocalSupplier(this.txtFDAReg.Text, false);
				localSupplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
				localSupplier.UpdateLocalSupplier(Common.UpdateFunction.UC001FrmProcessShipmentIn);

				this.txtFDAReg.Text = this._bloodUnit.UnitFdaRegistrationNumber;
				
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.btnFDARegNo, string.Empty);

				this.bloodUnitLabel1.Refresh();
			}
				//BOL throws BOL exception if invalid FDA reg
			catch (BOL.BusinessObjectException err)
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.btnFDARegNo, err.Message);
				System.Diagnostics.Debug.WriteLine(err.Message);
			}
		}
			
		private bool UnitBarcodeTypeMatchesShipmentType(ref string message)
		{
			if( ( this.Codabar && txtProduct.BarcodeType == Common.BarcodeType.ISBT128 ) ||
				( !this.Codabar && txtProduct.BarcodeType == Common.BarcodeType.Codabar ) )
			{
				message = this.Codabar ? Common.StrRes.Tooltips.UC001.NoISBTUnitsInCodabarShipment().ResString : Common.StrRes.Tooltips.UC001.NoCodabarUnitsInISBTShipment().ResString; 
				this.txtProduct.Text = string.Empty;
				this.txtUnitID.Text = string.Empty;

				return false;
			}
			return true;
		}

		private void HandleProductCodeLeave()
		{
			try
			{		
				string error = string.Empty;
				string message = string.Empty;
				if(!UnitBarcodeTypeMatchesShipmentType(ref message))
				{
					return;
				}
				// If ISBT and a field other than product is scanned
				if (txtProduct.isbtScan != Common.ISBTScan.ProductCode && txtProduct.isbtScan != Common.ISBTScan.Unknown)
				{
					this.txtProduct.Text = String.Empty;
				}
				
				if (txtProduct.Text != string.Empty)			
				{
					this.IsDirty = true;
					string productText = this.txtProduct.Text;
					this._bloodUnit.ProductCode = txtProduct.Text;
					char donationType = this._bloodUnit.DonationType.DonationTypeCode;
					if(!this.Codabar && productText.Length < 8)
					{
						this._bloodUnit.UnitDivisionId = "00";
						txtProduct.Text = _bloodUnit.FullProductCode;
					}
					
					
					this.bloodUnitLabel1.Refresh();
					
					if (!this.Codabar)
					{
						if (txtProduct.Text.Length > 7)
						{
							this._bloodUnit.UnitDivisionId = txtProduct.Text.Substring(6,2);
						}
						else
						{
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.btnProductCode, Common.StrRes.SysErrMsg.UC001.EightCharactersRequiredForProductCode().ResString);
							return;
						}

						if (this.txtProduct.BarcodeType == Common.BarcodeType.Codabar)
						{
							error = Common.StrRes.SysErrMsg.Common.ISBTProductCode().ResString; 
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.btnProductCode, error);
						}
												
						this.cmbType.Text = this.GetDonationTypeText(donationType);;

						this._bloodUnit.DonationType.DonationTypeCode = donationType;
						char zero = "0".ToCharArray()[0];
						char donationTypeCode = this._bloodUnit.DonationType.DonationTypeCode;
						if((donationTypeCode.Equals(zero) || donationTypeCode.Equals("Q".ToCharArray()[0]))
							&& !this.Codabar)
						{
							this.cmbType.Enabled = true;
						}
						
					
						switch (this._bloodUnit.DonationType.DirectedType)
						{
								//BR 1.34, 1.35, 1.37
								//Autologous
							case "A":
								this.cmbTestingStatus.Enabled = true;
								break;
								//Directed
							case "D":
								// set this to null if changed to something else from autologous
								this.cmbTestingStatus.Text = String.Empty;
								this.cmbTestingStatus.SelectedIndex = 0;
								this._bloodUnit.BloodUnitMedia.TestingStatusId = 0;
								this.cmbTestingStatus.Enabled = false;
								break;
								//Homologous (Allogeneic)
							default:
								// set this to null if changed to something else from autologous
								this.cmbTestingStatus.Text = String.Empty;
								this.cmbTestingStatus.SelectedIndex = 0;
								this._bloodUnit.BloodUnitMedia.TestingStatusId = 0;
								//If full service then do not require restricted for patient.
								if(ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
								{
									this._bloodUnit.DirectedPatient = new BOL.Patient();
								}
								this.cmbTestingStatus.Enabled = false;
								this.txtPatient.Text = String.Empty;
								break;
						}
						if(BOL.BloodUnit.IsDirected(donationTypeCode) || (BOL.BloodUnit.IsAutologous(donationTypeCode) || (!ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)))
						{
							this.btnSelectPatient.Enabled = true;
						}
						else
						{
							this.btnSelectPatient.Enabled = false;
						}
					}
					else 
					{
						if (this.txtProduct.BarcodeType == Common.BarcodeType.ISBT128)
						{
							error =  Common.StrRes.SysErrMsg.Common.CodabarProductCode().ResString;
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.btnProductCode, error);
						}
					}

					if (error.Length > 0)
					{
						this.txtProduct.SelectAll();
						txtProduct.Focus();
					}
					else 
					{
						this.txtProduct.ReadOnly = true;
						this.btnProductCode.Enabled = false;
						this.cmbABORh.LoadValues(this._bloodUnit);
						this.cmbABORh.Enabled = true;
					}
				}
				this.cmbABORh.DonationTypeId = this._bloodUnit.DonationType.DonationTypeId;
			}
				//BOL throws BOL exception if invalid product code is set
			catch(BOL.BusinessObjectException err)
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.btnProductCode,err.Message);
				this.bloodUnitLabel1.Refresh();
			}
			finally
			{
				this.txtProduct.Barcode = false;
			}
		}


		private void GetNewBloodUnit()
		{
			bool bValid = this.errError.GetError(this.txtUnitID).Length == 0 && this.errError.GetError(this.btnProductCode).Length == 0 && this.errError.GetError(this.txtCheckCharacter).Length == 0; 
			if(this.txtProduct.Text.Length > 0 && this.txtUnitID.Text.Length > 0 && bValid)
			{
				Common.BarcodeType barcodeType;
				if(this.Codabar)
				{
					barcodeType = Common.BarcodeType.Codabar;
				}
				else
				{
					barcodeType = Common.BarcodeType.ISBT128;
				}
				try
				{
					if(this._bloodUnit == null)
					{
						this._bloodUnit = new BOL.BloodUnit(this.txtUnitID.Text, this.txtProduct.Text, barcodeType, this._bloodProduct.BloodProductGuid); 
					}
					else
					{
						string sTest = this.txtProduct.Text.Substring(0,5);
						if(this._bloodUnit.EyeReadableUnitId != this.txtUnitID.Text || this._bloodUnit.ProductCode != this.txtProduct.Text.Substring(0,5))
						{
							this._bloodUnit = new BOL.BloodUnit(this.txtUnitID.Text, this.txtProduct.Text, barcodeType, this._bloodProduct.BloodProductGuid); 
						}
						else
						{
							return;
						}
					}
				}
				catch (BOL.BusinessObjectException exp)
				{
					if(!_isUnloading)
					{
						this._bloodUnit = null;
						if(exp.Message.ToString().IndexOf("Product") > -1 || exp.Message.ToString().IndexOf("product") > -1)
						{
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.btnProductCode, exp.Message);
							this.txtProduct.Barcode = false;
							this.txtProduct.Focus();
						}
						else if(exp.Message.ToString().IndexOf("Donation") > -1 || exp.Message.ToString().IndexOf("donation") > -1)
						{
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.btnProductCode, "Invalid donation type code.");
							this.txtProduct.Focus();
						}
						else 
						{
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.txtCheckCharacter, exp.Message);
							this.txtUnitID.ReadOnly = false;
							this.txtUnitID.ReadOnly = false;
							this.txtUnitID.Barcode = false;
							this.txtUnitID.Focus();
						}
						return;
					}
					else
					{
						return;
					}
				}

				
				if(this.Codabar == true)
				{
					//BR 1.36
					this._bloodUnit.DonationType.DonationTypeCode = Common.Utility.GetDonationTypeCodeCharFromEnum(Common.DonationType.VolunteerAllogeneicDonor);
					this._bloodUnit.BarcodeType = Common.BarcodeType.Codabar;
				}
				else
				{
					this._bloodUnit.BarcodeType = Common.BarcodeType.ISBT128;					
				}
				
				this._bloodUnit.IsReadOnly = false;
				this._bloodUnit.UnitInDate = this._shipment.ShipmentDate;
				SetEvents();
				this.CallHandleMethods();
				this.bloodUnitLabel1.BloodUnit = this._bloodUnit;
				this.cmbType.Text = this._bloodUnit.DonationType.DonationTypeText;
				
				this.txtCheckCharacter.ReadOnly = true;
				this.txtCheckCharacter.TabStop = false;

			}
			if(this.Codabar && this._bloodUnit != null)
			{
				this.HandleFDARegLeave();
			}
		}
		private void ResetScreenDuplicateUnit()
		{
			this.Clear();
			this.Clear();
			ResetFocus();
		}

		private void CallHandleMethods()
		{
			if(this.txtFDAReg.Text.Length > 0)
			{
				this.HandleFDARegLeave();
			}
			
			if(this.cmbABORh.Text.Length > 0)
			{
				this.HandleABORhLeave();
			}

			if(this.dtpExpiration.Value.Date != BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date)
			{
				this.HandleExpirationDateLeave();
			}

			if(this.cmbType.Text.Length > 0)
			{
				this.HandlecmbTypeChange();
			}

			if(this.cmbTestingStatus.Text.Length > 0)
			{
				this.HandlecmbTestingStatusChange();
			}

			this.HandleSpecialTestingCostLeave();

			if(this.txtCheckCharacter.Text.Length > 0)
			{
				txtCheckCharacter_Leave(this, new System.EventArgs());
			}
		}
		
		private void HandleUnitIDLeave()
		{
			try
			{
				string labelUnitID = string.Empty;
				bool alphaCharactersPresent = false;
				//Generating the alphaCharPresent calculation
				labelUnitID = this._bloodUnit.GenerateNumericCodabarUnitID(this.txtUnitID.Text, ref alphaCharactersPresent);;
				string sUnitID = this.txtUnitID.Text;
				string message = string.Empty;
				
				//BR_1.05
				this._bloodUnit.EntryMethodCode = (this.txtUnitID.Barcode == true) ? "S" : "M";
				if(!UnitBarcodeTypeMatchesShipmentType(ref message))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(message));

					this.txtProduct.BarcodeType = Common.BarcodeType.None;
					this.txtUnitID.BarcodeType = Common.BarcodeType.None;

					if(this.codabar)
					{
						this.txtFDAReg.Focus();
						this.Clear();
						this.Clear();
					}
					else
					{
						this.txtUnitID.Focus();
						this.Clear();
						this.Clear();
					}
					return;
				}
				

				// BR 1.08
				// This handles the condition when a user scans a barcode that is not a Unit ID into this field.
				if (txtUnitID.isbtScan != Common.ISBTScan.UnitId && txtUnitID.isbtScan != Common.ISBTScan.Unknown)
				{
					this.txtUnitID.Text = String.Empty;
					return;
				}

				// BR 1.19
				// if ISBT and manually entered, enable check character txtBox	
				if (!Codabar && !this.txtUnitID.Barcode)
				{
					if(this.txtUnitID.Text.Trim().Length > 0)
					{
						this.IsDirty = true;
						if(this.txtCheckCharacter.ReadOnly && this.txtCheckCharacter.Text.Length == 0 && this.txtUnitID.ReadOnly == false)
						{
							this.txtCheckCharacter.ReadOnly = false;
							this.txtCheckCharacter.TabStop = true;
						}
					}
				}
				else
				{
					this.txtCheckCharacter.ReadOnly = true;
					this.txtCheckCharacter.TabStop = false;
					this._bloodUnit.CheckCharacter = "X";
				}
				if(Codabar)
				{
					//CR 3104
					this.txtCheckCharacter.ReadOnly = true;
					this.txtCheckCharacter.TabStop = false;
					//BR_1.05
					//The system must evaluate any manually entered number for rules entered in UC_06 associated with that FDA registration number and collection facility evaluating and allowing entry only when:
					//the entered Unit ID follows the rules as either all numerics or alphanumerics as defined for the collection facility
					//the entered 1.0 matches the previously defined prefix for the collection facility 
					string validMessage;
					this._bloodUnit.CheckValidUnitIDForLocalSupplier(this.txtUnitID.Text, out validMessage);
					if(validMessage.Trim().Length > 0)
					{
						// **** 508 Compliance ***
						this.errError.SetVbecsError(txtUnitID, validMessage);
						return;
					}
				}
				if ( (Codabar && (this.txtUnitID.BarcodeType == Common.BarcodeType.ISBT128)) ||
					(!Codabar && (this.txtUnitID.BarcodeType == Common.BarcodeType.Codabar)))
				{
					// **** 508 Compliance ***
					this.errError.SetVbecsError(txtUnitID, Common.StrRes.SysErrMsg.UC001.IncorrectUnitID().ResString);
					return;
				}
				else
				{	 	
					//If its codabar and they typed it in set the labelunitid and eyereadable
					if (Codabar  && this.txtUnitID.Barcode == false)
					{
						// Converts any alphanumeric character to numeric  //07/25/2005
						this._bloodUnit.SetLabelUnitId(this._bloodUnit.GenerateNumericCodabarUnitID(this.txtUnitID.Text, ref alphaCharactersPresent), true);
						//this._bloodUnit.LabelUnitId = this._bloodUnit.GenerateNumericCodabarUnitID(this.txtUnitID.Text, ref alphaCharactersPresent);
									

						//07/25/2005
						this._bloodUnit.SetEyeReadableUnitId(sUnitID, true);
						//this._bloodUnit.EyeReadableUnitId = sUnitID;
						
						// **** 508 Compliance ***
						this.errError.SetVbecsError(txtUnitID, string.Empty);
					}
						//You only want to generate an eye readable if it was scanned.
					else if(Codabar  && this.txtUnitID.Barcode)
					{
						Regex isbtUnitID = Common.RegularExpressions.ISBT128UnitID();
						
						//07/25/2005 
						this._bloodUnit.SetLabelUnitId(labelUnitID, true);
						//this._bloodUnit.LabelUnitId = labelUnitID;
						if(!isbtUnitID.IsMatch(this.txtUnitID.Text))
						{
							try
							{
								this._bloodUnit.GenerateEyeReadableUnitID();
							}
							catch(BOL.BusinessObjectException exp)
							{
								// **** 508 Compliance ***
								this.errError.SetVbecsError(txtUnitID, exp.Message);
								return;
							}
							if(this._bloodUnit != null)
							{
								this.bloodUnitLabel1.BloodUnit = this._bloodUnit;
							}
						}
					}
					
					
					//ISBT
					if(!Codabar)
					{
						this._bloodUnit.SetLabelUnitId(sUnitID, true);
						this._bloodUnit.SetEyeReadableUnitId(sUnitID, true);
					}
						//Codabar
					else
					{
						//07/25/2005
						this._bloodUnit.SetLabelUnitId(this._bloodUnit.GenerateNumericCodabarUnitID(this.txtUnitID.Text, ref alphaCharactersPresent), true);
						if(this._bloodUnit.EyeReadableUnitId.Trim().Length == 0 && txtUnitID.Barcode)
						{
							Regex isbtUnitID = Common.RegularExpressions.ISBT128UnitID();
							if(!isbtUnitID.IsMatch(this.txtUnitID.Text))
							{
								try
								{
									this._bloodUnit.GenerateEyeReadableUnitID();
								}
								catch(BOL.BusinessObjectException exp)
								{
									// **** 508 Compliance ***
									this.errError.SetVbecsError(txtUnitID, exp.Message);
									return;
								}
								if(this._bloodUnit != null)
								{
									this.bloodUnitLabel1.BloodUnit = this._bloodUnit;
								}
							}
						}
						else if(!alphaCharactersPresent && this._bloodUnit.EyeReadableUnitId.Length == 0)
						{
							//07/25/2005
							this._bloodUnit.SetEyeReadableUnitId(this._bloodUnit.LabelUnitId, true);
						}
					}
					
					txtUnitID.Text = this._bloodUnit.EyeReadableUnitId;
					
					// **** 508 Compliance ***
					this.errError.SetVbecsError(txtUnitID, string.Empty);
				}
				this.txtUnitID.ReadOnly = true;
				if(this._bloodUnit.BloodProductGuid == System.Guid.Empty)
				{
					this.GetBloodProduct(this.txtProduct.Text.Trim());
					this.LoadBloodProduct(this._bloodProduct);
				}
				this.bloodUnitLabel1.Refresh();
			}
				//Unit ID validation causes BOL exception
			catch (BOL.BusinessObjectException ex)
			{
				if(!_isUnloading)
				{
					this.txtUnitID.SelectAll();
					// **** 508 Compliance ***
					this.errError.SetVbecsError(txtUnitID, ex.Message);
				}
			}
			catch(Exception ex)
			{
				if(!_isUnloading)
				{
					this.txtUnitID.SelectAll();
					this.txtUnitID.Focus();
					// **** 508 Compliance ***
					this.errError.SetVbecsError(txtUnitID, ex.Message);
				}
			}
			finally
			{
				if(this._bloodUnit != null)
				{
					if(this._bloodUnit.ProductCode.Length > 0)
					{
						if (this.errError.GetError(this.txtUnitID).Length == 0 && this.errError.GetError(this.txtProduct).Length == 0)
						{
							this.txtProduct.ReadOnly = true;
							this.txtUnitID.ReadOnly = true;
							this.btnProductCode.Enabled = false;
							this.cmbABORh.LoadValues(this._bloodUnit);
							this.cmbABORh.Enabled = true;
							this.cmbABORh.Focus();
						}
					}
				}
				this.txtUnitID.Barcode = false;
			}
		}
		
		private void txtUnitID_Leave(object sender, System.EventArgs e)
		{
			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					//CR 3145
					if(!Codabar && txtUnitID.isbtScan != Common.ISBTScan.UnitId && txtUnitID.isbtScan != Common.ISBTScan.Unknown)
					{
						this.txtUnitID.Text = String.Empty;
						this.errError.SetVbecsError(this.txtUnitID, Common.StrRes.InfoMsg.Common.IncorrectBarcode().ResString);
						return;
					}
					// BR 1.19
					// if ISBT and manually entered, enable check character txtBox	
					// The textbox stays set to barcode even when manually changed, hence the flag.
					if (!Codabar && !this.txtUnitID.Barcode)
					{
						if(this.txtUnitID.Text.Trim().Length > 0)
						{
							this.IsDirty = true;
							if(this.txtCheckCharacter.ReadOnly && this.txtCheckCharacter.Text.Length == 0 && this.txtUnitID.ReadOnly == false)
							{
								this.txtCheckCharacter.ReadOnly = false;
								this.txtCheckCharacter.TabStop = true;
								this.txtCheckCharacter.Focus();
							}
							else
							{
								this.txtCheckCharacter.TabStop = false;
							}
						}
					}
					else if(Codabar || !this.txtUnitID.Barcode)
					{
						this.txtCheckCharacter.ReadOnly = true;
						this.txtCheckCharacter.TabStop = false;
						this.txtCheckCharacter.Text = string.Empty;
						this.txtProduct.Focus();
					}
			
					if(this.txtUnitID.Text.Trim().Length > 13)
					{					
						this.txtUnitID.Text = this.txtUnitID.Text.Substring(0, 13);
					}

					if(!this.txtUnitID.UnitIDValid)
					{
						// **** 508 Compliance ***
						this.errError.SetVbecsError(this.txtCheckCharacter, Common.StrRes.InfoMsg.Common.IncorrectBarcode().ResString);
						this.txtUnitID.Text = String.Empty;
						this.txtUnitID.ReadOnly = false;
						this.txtProduct.ReadOnly = false;
						return;
					}
					else
					{
						// **** 508 Compliance ***
						this.errError.SetVbecsError(this.txtCheckCharacter, String.Empty);
						this.errError.SetVbecsError(this.txtUnitID, String.Empty);
					}
					Regex isbtUnitID = Common.RegularExpressions.ISBT128UnitID();
					if(!isbtUnitID.IsMatch(this.txtUnitID.Text))
					{
						if(this._localSupplier != null && this.Codabar && this.txtUnitID.Barcode)
						{
							try
							{
								this.txtUnitID.Text = BOL.BloodUnit.GenerateEyeReadableUnitID(this._localSupplier, this.txtUnitID.Text);
							}
							catch(BOL.BusinessObjectException exp)
							{
								// **** 508 Compliance ***
								this.errError.SetVbecsError(this.txtUnitID, exp.Message);
								return;
							}
							if(this._bloodUnit != null)
							{
								this.bloodUnitLabel1.BloodUnit = this._bloodUnit;
							}
						}
					}
					if(!this.Codabar)
					{
						if(this.txtUnitID.Text.IndexOf("=") > -1)
						{
							if(this.txtUnitID.Text.Length >= 6)
							{
								this.IsDirty = true;
								Regex iccbbaRegex = Common.RegularExpressions.IccbbaRegistrationNumber();
				
								//BR_6.11 - validate the ICCBBA format
								if ((this.txtUnitID.Text.Substring(1,5).Trim().Length > 0) && (!iccbbaRegex.IsMatch(this.txtUnitID.Text.Substring(1,5).Trim())))
								{
									string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod(
										Common.Utility.ParseStringwithSpaces("ICCBBA Registration Number", true ),
										this.txtUnitID.Text.Substring(1,5).Trim() ).ResString;

									// **** 508 Compliance ***
									this.errError.SetVbecsError(this.txtUnitID, errorMessage);
									return;
								}
								if(!BOL.LocalSupplier.IsLocalSupplierActiveByIccbbaRegistrationNumber(this.txtUnitID.Text.Substring(1,5)))
								{
									BOL.LocalSupplier localSupplier = new BOL.LocalSupplier(false, this.txtUnitID.Text.Substring(1,5));
									if(localSupplier.RecordStatusCode == Common.RecordStatusCode.NationalStandard)
									{
										localSupplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
										localSupplier.InsertLocalSupplier(Common.UpdateFunction.UC001FrmProcessShipmentIn);
									}
									else if(localSupplier.RecordStatusCode == Common.RecordStatusCode.Inactive  && !localSupplier.IsNew)
									{
										localSupplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
										localSupplier.UpdateLocalSupplier(Common.UpdateFunction.UC001FrmProcessShipmentIn);
									}
									else if(localSupplier.RecordStatusCode == Common.RecordStatusCode.Inactive  && localSupplier.IsNew)
									{
										if(GoToUC06(true) != true)
										{
											this.txtUnitID.SelectAll();
											this.txtUnitID.Focus();
											return;
										}
									}			
								}
							}
						}
						else
						{
							if(this.txtUnitID.Text.Length >= 5)
							{
								this.IsDirty = true;
								Regex iccbbaRegex = Common.RegularExpressions.IccbbaRegistrationNumber();
				
								//BR_6.11 - validate the ICCBBA format
								if ((this.txtUnitID.Text.Substring(0,5).Trim().Length > 0) && (!iccbbaRegex.IsMatch(this.txtUnitID.Text.Substring(0,5).Trim())))
								{
									string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod(
										Common.Utility.ParseStringwithSpaces("ICCBBA Registration Number", true ),
										this.txtUnitID.Text.Substring(0,5).Trim() ).ResString;

									// **** 508 Compliance ***
									this.errError.SetVbecsError(this.txtUnitID, errorMessage);
									return;
								}
								BOL.LocalSupplier localSupplier = new BOL.LocalSupplier(false, this.txtUnitID.Text.Substring(0,5));
								
								if(!BOL.LocalSupplier.IsLocalSupplierActiveByIccbbaRegistrationNumber(this.txtUnitID.Text.Substring(0,5)))
								{
									if(localSupplier.RecordStatusCode == Common.RecordStatusCode.NationalStandard)
									{
										localSupplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
										localSupplier.InsertLocalSupplier(Common.UpdateFunction.UC001FrmProcessShipmentIn);
									}
									else if(localSupplier.RecordStatusCode == Common.RecordStatusCode.Inactive  && !localSupplier.IsNew)
									{
										localSupplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
										localSupplier.UpdateLocalSupplier(Common.UpdateFunction.UC001FrmProcessShipmentIn);
									}
									else if(localSupplier.RecordStatusCode == Common.RecordStatusCode.Inactive  && localSupplier.IsNew)
									{
										if(GoToUC06(true) != true)
										{
											this.txtUnitID.SelectAll();
											this.txtUnitID.Focus();
											return;
										}
									}			
									
								}
							}
						}
					}
					GetNewBloodUnit();
					if(!this.Codabar && this.txtUnitID.Barcode)
					{
						this.txtCheckCharacter.ReadOnly = true;
						this.txtCheckCharacter.TabStop = false;
						this.txtCheckCharacter.Text = string.Empty;
						this.txtProduct.Focus();
					}
		
					if(this._bloodUnit != null)
					{
						this.HandleUnitIDLeave();
						//CR 2824
						this.HandleProductCodeLeave();
					}
				}
				finally
				{
					this.CheckValid(sender, e);
					this.RecursionGuard = false;
				}
			}
          
		}

		private void txtUnitID_TextChanged(object sender, System.EventArgs e)
		{	
			if(this.txtUnitID.Text == "~" && this.txtUnitID.ReadOnly == false)
			{
				this.txtCheckCharacter.ReadOnly = false;
				this.txtCheckCharacter.TabStop = true;
				this.txtCheckCharacter.Text = string.Empty;
				this.txtUnitID.Barcode = true;
			}
			
			// **** 508 Compliance ***
			this.errError.SetVbecsError(this.txtCheckCharacter, string.Empty);
			
			if(!this.txtUnitID.Barcode && this.txtUnitID.Text.Trim().Length > 13)
			{
				this.txtUnitID.Text = this.txtUnitID.Text.Substring(0, 13);
			}
			this.IsDirty = true;
			if( _bloodUnit == null ) return;
		
		}

		private void HandleABORhLeave()
		{
			
			if(!this.cmbABORh.AboRHValid)
			{
				this.cmbABORh.Text = string.Empty;
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.cmbABORh,Common.StrRes.SysErrMsg.UC001.IncorrectABORH().ResString);
				return;
			}
			this.IsDirty = true;
			try
			{
				this._bloodUnit.BloodUnitMedia.AboRh.Abo = cmbABORh.Abo;
				this._bloodUnit.BloodUnitMedia.AboRh.RH = (Common.RH) cmbABORh.RH;
				this.bloodUnitLabel1.BloodUnit = this._bloodUnit;
				this.bloodUnitLabel1.Refresh();
				if (cmbABORh.Text.Trim() == String.Empty)
				{
					this._bloodUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.NA;
					this._bloodUnit.BloodUnitMedia.AboRh.RH = Common.RH.NotProvided;
					this.bloodUnitLabel1.Refresh();
				}
			}
			catch
			{
				if(this._bloodUnit == null)
				{
					this.Clear();
					return;
				}
			}
		}

		private void cmbABORh_Leave(object sender, System.EventArgs e)
		{
			if(!this.cmbABORh.AboRHValid)
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.cmbABORh, Common.StrRes.InfoMsg.Common.IncorrectBarcode().ResString);
				this.cmbABORh.Text = String.Empty;
				return;
			}
			else
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.cmbABORh, String.Empty);
			}
			if(this._bloodUnit != null)
			{
				this.HandleABORhLeave();
			}
			this.cmbABORh.Barcode = false;
		}

		private void HandleExpirationDateLeave()
		{
			if( this._isLoading ) return;
			
			if (this.dtpExpiration.VisibleText == string.Empty) return;
			try
			{
				if(this._bloodUnit.BloodUnitMedia == null) return;

				if (this.dtpExpiration.Value != this._bloodUnit.BloodUnitMedia.UnitExpirationDate)
				{
					this._bloodUnit.BloodUnitMedia.Comments = string.Empty;
				}
				if (dtpExpiration.IsValid)
				{
					this.IsDirty = true;
					//BR_1.61
					System.DateTime expirationDate = this.dtpExpiration.Value;
					System.TimeSpan timeDiff= expirationDate - this.Shipment.ShipmentDate;
					if(timeDiff.TotalMinutes < -1 && (dtpExpiration.Value != this._bloodUnit.BloodUnitMedia.UnitExpirationDate.Date))
					{
						if(this._bloodUnit.BloodUnitMedia.Comments.Length == 0)
						{
							System.Windows.Forms.DialogResult dlgRetVal = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC001.BR1_61());
							if(dlgRetVal == System.Windows.Forms.DialogResult.Yes)
							{
								DlgOverrideComment dlg =
									new med.vbecs.GUI.DlgOverrideComment
									("Invalid Expiration Date ", "Enter an exception report comment.", "IS");
								System.Windows.Forms.DialogResult result = dlg.ShowDialog(this);
								this._bloodUnit.BloodUnitMedia.Comments = dlg.Comment;
								if(result == System.Windows.Forms.DialogResult.OK)
								{
									// **** 508 Compliance ***
									this.errError.SetVbecsError(dtpExpiration, string.Empty);
									this._bloodUnit.BloodUnitMedia.UnitExpirationDate = this.dtpExpiration.Value;
								}
								else
								{
									return;
								}
							}
							else
							{
								this.dtpExpiration.ClearDateText();
								this.dtpExpiration.Barcode = false;
								this._bloodUnit.BloodUnitMedia.CheckValidExpiredExpirationDate(this.Shipment.ShipmentDate.Date, this.dtpExpiration.Value);
								// **** 508 Compliance ***
								this.errError.SetVbecsError(dtpExpiration, string.Empty);
								return;
							}
						}
						else
						{
							this.dtpExpiration.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
							this._bloodUnit.BloodUnitMedia.UnitExpirationDate = this.dtpExpiration.Value;
						}
					}
					else
					{
						this._bloodUnit.BloodUnitMedia.Comments = string.Empty;
						// **** 508 Compliance ***
						this.errError.SetVbecsError(dtpExpiration, string.Empty);
						this._bloodUnit.BloodUnitMedia.UnitExpirationDate = this.dtpExpiration.Value;
					}
			
					//Call to BR_1.31
					if(this._bloodUnit!= null)
					{	
						bool valid;
						this._bloodUnit.BloodUnitMedia.SetUnitExpirationDate(this.Shipment.ShipmentDate, dtpExpiration.Value, this._bloodUnit.MaximumStorageDays, this._bloodUnit.MaximumStorageHours, out valid);
						if(!valid)
						{
							//invalid
							// **** 508 Compliance ***
							this.errError.SetVbecsError(dtpExpiration, Common.StrRes.SysErrMsg.UC001.InvalidExpirationDateMaxStorageTime().ResString);
							return;
						}
						else
						{
							// **** 508 Compliance ***
							this.errError.SetVbecsError(dtpExpiration, string.Empty);
						}
					}
				}
				else
				{
					//invalid
					this.dtpExpiration.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					this.dtpExpiration.ClearDateText();
					// **** 508 Compliance ***
					this.errError.SetVbecsError(dtpExpiration, Common.StrRes.SysErrMsg.UC001.InvalidExpirationDate().ResString);
					this.btnAdd.EnabledButton = false;
					return;
				}
				this.bloodUnitLabel1.Refresh();
			}
			catch
			{
				if(this._bloodUnit == null)
				{
					this.Clear();
					return;
				}
			}
		}

		private void dtpExpiration_Leave(object sender, System.EventArgs e)
		{
			CallHandleExpirationDate();
			this.dtpExpiration.Barcode = false;
		}


		private void btnAdd_MouseHover(object sender, System.EventArgs e)
		{
			// **** 508 Compliance ***
			btnAdd.SetToolTip( GetAddButtonToolTip() );
		}

		private void cmbABORh_AboRHFound(object sender, System.EventArgs e)
		{
			// **** 508 Compliance ***
			this.errError.SetVbecsError(cmbABORh, string.Empty);
		}

		private void cmbABORh_AboRHNotFound(object sender, System.EventArgs e)
		{
			// **** 508 Compliance ***
			this.errError.SetVbecsError(cmbABORh, Common.StrRes.SysErrMsg.UC001.ABORhNotFound().ResString);
		}

		private void btnSelectPatient_Click(object sender, System.EventArgs e)
		{
			if( _bloodUnit == null )
			{
				GuiMessenger.ShowMessageBox	(Common.StrRes.ValidMsg.UC001.UnitBeforePatient());
				return;
			}
			try
			{
				FrmPatientSelect frm = new FrmPatientSelect(true);

				if (frm.ShowDialog(this) == DialogResult.OK)
				{
					if(frm.SelectedPatient != null)
					{
						this._bloodUnit.DirectedPatient = (BOL.Patient)frm.SelectedPatient;
						this.txtPatient.Text = this._bloodUnit.DirectedPatient.DisplayName;
						// **** 508 Compliance ***
						this.errError.SetVbecsError(btnSelectPatient, string.Empty);
						this.IsDirty = true;
						this.CheckValid(sender, e);
					}
					else
					{
						//UC1.BR137.PatientNotFound
						// **** 508 Compliance ***
						this.errError.SetVbecsError(btnSelectPatient, Common.StrRes.Tooltips.UC001.BR137_RestrictPatient().ResString);
					}

				}
				else
				{
					this._bloodUnit.DirectedPatient = null;
					this.txtPatient.Text = string.Empty;
					// **** 508 Compliance ***
					this.errError.SetVbecsError(btnSelectPatient, Common.StrRes.SysErrMsg.UC001.NoPatientFound().ResString);
				}
			}
			catch
			{
				if(this._bloodUnit == null)
				{
					this.Clear();
					return;
				}
			}
		}

		private void HandleSpecialTestingCostLeave()
		{
			try
			{
				if(_bloodUnit != null)
				{
					_bloodUnit.BloodUnitFinance.SpecialTestingCost = this.updSpecialTestingCost.Value;
				}
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.updSpecialTestingCost,string.Empty);
			}
			catch(FormatException err)
			{
				_bloodUnit.BloodUnitFinance.SpecialTestingCost = decimal.MinusOne;
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.updSpecialTestingCost,err.Message);
			}
			catch
			{
				if(this._bloodUnit == null)
				{
					this.Clear();
					return;
				}
			}
		}

		private void HandleSpecialTestingCostChanged()
		{
			try
			{
				if(_bloodUnit != null)
				{
					_bloodUnit.BloodUnitFinance.SpecialTestingCost = this.updSpecialTestingCost.Value;
				}
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.updSpecialTestingCost,string.Empty);
			}
			catch(FormatException)
			{
				_bloodUnit.BloodUnitFinance.SpecialTestingCost = decimal.MinusOne;
			}
			catch
			{
				if(this._bloodUnit == null)
				{
					this.Clear();
					return;
				}
			}

		}

		private void HandlecmbTestingStatusChange()
		{
			if( this._isLoading ) return;
			if(this._bloodUnit == null) return;
			try
			{
				if(( cmbTestingStatus.Text == String.Empty ) || (cmbTestingStatus.SelectedIndex<0))
				{
					this._bloodUnit.BloodUnitMedia.TestingStatusId = int.MinValue;
					// **** 508 Compliance ***
					errError.SetVbecsError(cmbTestingStatus, string.Empty);				
					return;
				}
				this.IsDirty = true;
				this._bloodUnit.BloodUnitMedia.TestingStatusId = this.GetTestingStatusID(this.cmbTestingStatus.Text);
			

				if ( !_bloodUnit.DonationType.DirectedType.Equals("A") ) return;
			}
			catch
			{
				if(this._bloodUnit == null)
				{
					this.Clear();
					return;
				}
			}
		
		}

		private void cmbTestingStatus_SelectedIndexChanged(object sender, System.EventArgs e)
		{

			if(this._bloodUnit != null)
			{
				this.HandlecmbTestingStatusChange();
				this.bloodUnitLabel1.Refresh();
			}
		}

		private bool Save()
		{
			bool bRetVal = false;
			try
			{
				DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC001.AddUnit());
				if (result == DialogResult.Yes)
				{
					if (_shipment.ShipmentGuid == Guid.Empty)
					{
						_shipment.ShipmentGuid = Guid.NewGuid();
					}
					System.Collections.ArrayList alBloodUnitTests = new System.Collections.ArrayList();
					// to save the special tests
					Hashtable tests = (Hashtable) this.specialTestingHash[this._bloodUnit.BloodUnitGuid];
					if(tests != null)
					{
						IDictionaryEnumerator enumerator = tests.GetEnumerator(); 
						while (enumerator.MoveNext())
						{
							if (!enumerator.Key.ToString().Trim().Equals(this._cmvNeg.ToString()) && !enumerator.Key.ToString().Trim().Equals(this._sickleCell.ToString()))
							{
								continue;
							}
							int bloodTestTypeID = System.Convert.ToInt32(enumerator.Key.ToString());
							BOL.BloodUnitTest bloodUnitTest = new BOL.BloodUnitTest(this._bloodUnit.BloodUnitGuid, bloodTestTypeID);
							bloodUnitTest.TestDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
						
							if(enumerator.Value != null)
							{
								if( (bool) enumerator.Value )
								{
									bloodUnitTest.TestResultId = "P";		
								}
								else
								{
									bloodUnitTest.TestResultId = "N";
								}
							}
							bloodUnitTest.EntryMethodCode = (string) Common.Utility.GetTestEntryMethodCodeFromTestEntryMethodEnum(Common.TestEntryMethod.Manual);
							bloodUnitTest.TestComments = String.Empty;
							bloodUnitTest.LastUpdateUser = ThisUser.UserNTLoginID;
							alBloodUnitTests.Add(bloodUnitTest);
						}
					}
					//Shipment has to be added here to get a real shipment GUID rather than an empty one
					this._bloodUnit.IncomingShipmentGuid= _shipment.ShipmentGuid;
			
					_shipment.DivisionCode = LogonUser.LogonUserDivisionCode;
					this._bloodUnit.ProcessingTechId = this.ProcessingTechId;
					this._bloodUnit.IncomingShipment.ShipmentDate = _shipment.ShipmentDate;
					//Save BloodUnitAntigens
					_shipment.SaveIncomingShipment(this._bloodUnit, this._reenteredUnit, this._alBloodUnitAntigens, alBloodUnitTests, Common.UpdateFunction.UC001FrmProcessShipmentIn, this._listItem, _workloadProcessID);
					bRetVal = true;
				}
			}
			catch(RowVersionException)
			{
				this.btnAdd.RowVersionException = true;			//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
			//CR 1441
			System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) _workloadProcessID);
			if(dt!= null && _workloadProcessID != Common.WorkloadProcessID.Unknown)
			{
				if(dt.Rows.Count == 0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
				}
			}
			return bRetVal;
		}
		
		private void lvShipmentUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{

			if (e.Column == 3)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvShipmentUnits.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvShipmentUnits.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void cmbType_MouseHover(object sender, System.EventArgs e)
		{
			if (this.cmbType.SelectedIndex > -1)
			{
				this.ttProduct.SetToolTip(this.cmbType,this.cmbType.Text);		
			}
			else
			{
				this.ttProduct.SetToolTip(this.cmbType,Common.StrRes.SysErrMsg.UC001.NoDonationType().ResString);
			}
		}

		private void cmbTestingStatus_MouseHover(object sender, System.EventArgs e)
		{
			if (this.cmbTestingStatus.SelectedIndex > -1)
			{
				this.ttProduct.SetToolTip(this.cmbTestingStatus,this.cmbTestingStatus.Text);		
			}
			else
			{
				this.ttProduct.SetToolTip(this.cmbTestingStatus,Common.StrRes.SysErrMsg.UC001.NoDiseaseMarkerTesting().ResString);
			}
		}

	
		#region Methods

		private string GenerateCheckNumber(string input)
		{
			int charValue;
			int sum = 0;
			bool isDigit = false;
			bool isAlpha = false;
		
			char[] charArray = input.ToCharArray();

			for (int x=0; x<input.Length; x++)
			{
				isDigit = (charArray[x] >= '0' && charArray[x] <= '9');	
				isAlpha = (charArray[x] >= 'A' && charArray[x] <= 'Z');	
			
				if (isDigit || isAlpha)
				{
					if (isDigit)
					{
						int number= (int) char.GetNumericValue(charArray[x]);
						charValue = charArray[x] - '0';
					}
					else 
					{
						charValue = charArray[x] - 'A' + 10;
					}

					sum = ((sum + charValue) * 2) % 37;
				}
			}
			char[] ISO7064Values = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ*".ToCharArray();

			return ISO7064Values[ (char) ( (38 - sum) % 37 ) ].ToString();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}



	
		private bool IsBloodUnitInList()
		{
			if(this._bloodUnit == null) return( false );

			for (int i = 0; i <= this.lvShipmentUnits.Items.Count -1; i++)
			{
				BOL.BloodUnit listBloodUnit = (BOL.BloodUnit) lvShipmentUnits.Items[i].Tag;
				if ((this._bloodUnit.ProductCode == listBloodUnit.ProductCode) 
					&& (this._bloodUnit.LabelUnitId == listBloodUnit.LabelUnitId))
				{
					return( true );
				}
			}

			return( false );
		}

		private void UnitListChanged()
		{
			okButtonToolTipText = Common.StrRes.Tooltips.UC001.MustbeUnitinIncomingShipmentTable().ResString;

			for (int i = 0; i < this.lvShipmentUnits.Items.Count; i++)
			{
				if (this.lvShipmentUnits.Items[i].Checked == true)
				{
					okButtonToolTipText = Common.StrRes.Tooltips.UC001.ClicktoSaveShipment().ResString;
					return;
				}
			}
		}

		private void SetEvents()
		{
			this._bloodUnit.Valid += new System.EventHandler(CheckValid);
			this._bloodUnit.Invalid += new System.EventHandler(CheckValid);
			this._bloodUnit.Valid += new System.EventHandler(CheckValid);
			this._bloodUnit.Invalid += new System.EventHandler(CheckValid);
			this._bloodUnit.DonationType.Valid += new System.EventHandler(CheckValid);
			this._bloodUnit.DonationType.Invalid += new System.EventHandler(CheckValid);
			this._bloodUnit.BloodUnitMedia.Valid += new System.EventHandler(CheckValid);
			this._bloodUnit.BloodUnitMedia.Invalid += new System.EventHandler(CheckValid);

			this._bloodUnit.BloodUnitMedia.AboRh.Valid += new System.EventHandler(CheckValid);
			this._bloodUnit.BloodUnitMedia.AboRh.Invalid += new System.EventHandler(CheckValid);
			this._bloodUnit.BloodUnitFinance.Valid += new System.EventHandler(CheckValid);
			this._bloodUnit.BloodUnitFinance.Invalid += new System.EventHandler(CheckValid);

			this._bloodUnit.IsDirtyChanged += new System.EventHandler(CheckDirty);

			SetFormBoundBloodUnitInitialBrokenRules();
		}

		private void SetComponentProperties()
		{
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC001.DlgSelectIncomingShipment());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 

			vbecsLogo1.Title="Process Incoming Shipment";
			invoiceDisplayPanel1.IncomingShipment = true;
			btnAdd.Text = "&Save";
			btnAdd.EnabledButton = false;
			lvShipmentUnits.Items.Clear();

			// array list to hold antigen modifications
			this._alBloodUnitAntigens = new System.Collections.ArrayList();
			
			this.txtCheckCharacter.ReadOnly = true;
			this.specialTestingHash = new Hashtable();
			//this.updSpecialTestingCost.Maximum = 4;
		}
		private void SetUpFormNewBloodUnit()
		{
			this._isLoading = true;
			
			//this.btnAdd.Text = AddButtonText;
			
			this.specialTesting1.ResetSpecialTesting();
			this.txtUnitID.Text = string.Empty;
			this.txtProduct.Text = string.Empty;
			this.txtFDAReg.Text = string.Empty;
			this.cmbABORh.Text = string.Empty;
			this.txtCheckCharacter.Text = string.Empty;
			
			this.dtpExpiration.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpExpiration.ClearDateText();
			
			this.cmbType.SelectedIndex = 0;
			this.txtPatient.Text = string.Empty;
			this.cmbTestingStatus.Text = string.Empty;
			
			
			
			this.updSpecialTestingCost.Value = 0;
			//This is the worst control ever, you must 
				//read the value of the control in order for the control to redisplay its new value
			//this.updSpecialTestingCost.Value = this.updSpecialTestingCost.Value;
		
			if(Codabar)
			{
				this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC01.CodabarNoUnitInstance().ResString);
			}
			else
			{
				this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC001.NoUnitInstance().ResString);
			}
			this.btnAdd.EnabledButton = false;
			this._isLoading = false;
		}
		/// <summary>
		/// Sets form to blood bag values
		/// </summary>
		/// <param name="bu"></param>
		private void PopulateForm(BOL.BloodUnit bu)
		{		
			this._isLoading = true;
			//BR 1.33
			this._bloodUnit.DonationType.DonationTypeCode = Common.Utility.GetDonationTypeCodeCharFromEnum(Common.DonationType.VolunteerAllogeneicDonor);

			_bloodUnit = bu;

			_bloodUnit.BarcodeType = codabar ? Common.BarcodeType.Codabar : Common.BarcodeType.ISBT128;

			SetEvents();
	
			SetFormBoundBloodUnitInitialBrokenRules();
			//this.btnAdd.Text = UpdateButtonText;

			string aboRHText = _bloodUnit.BloodUnitMedia.AboRh.AboRHText;
			if(aboRHText.IndexOf("/") > -1)
			{
				this.cmbABORh.SelectedValue = _bloodUnit.BloodUnitMedia.AboRh.AboRHText.Replace("/"," ");
			}
			else
			{
				this.cmbABORh.SelectedValue = _bloodUnit.BloodUnitMedia.AboRh.AboRHText;
			}
			this.dtpExpiration.Value = _bloodUnit.BloodUnitMedia.UnitExpirationDate;
			
			this.cmbABORh.Text = _bloodUnit.BloodUnitMedia.AboRh.AboRHText;
			
			this.updSpecialTestingCost.Value = this._bloodUnit.BloodUnitFinance.SpecialTestingCost;
			this.btnClear.Enabled = _bloodUnit.IsDirty;
			this.btnAdd.Refresh();
			this.cmbType.SelectedText = this._bloodUnit.DonationType.DonationTypeText;
			this.cmbTestingStatus.SelectedText = this.GetTestingStatusText(this._bloodUnit.BloodUnitMedia.TestingStatusId);
			this.txtUnitID.Text = _bloodUnit.LabelUnitId;
			this.txtProduct.Text = _bloodUnit.ProductCode;
			this.txtPatient.Text = _bloodUnit.DirectedPatient.DisplayName;
			
			txtFDAReg.Text = this._bloodUnit.LocalSupplier.FDARegistrationNumber;
			
			this.bloodUnitLabel1.BloodUnit = this._bloodUnit;
			this.bloodUnitLabel1.Refresh();

			//populate specialTesting control
			Hashtable test = (Hashtable) this.specialTestingHash[_bloodUnit.BloodUnitGuid];
			if (test != null) 
			{
				specialTesting1.ReloadAntigens(test);
			}
			this._isLoading = false;
		}

		/// <summary>
		/// Loads special testing and donation type lookups
		/// </summary>
		private void LoadLists()
		{
			this._isLoading = true;

			//Special testing list
			specialTesting1.LoadAntigenList();
			specialTesting1.ResetSpecialTesting();
						
			// Disable this - it will be populated by the 6th character from the product code
			if (!this.Codabar) this.cmbType.Enabled = false;

			//Donation type list
			this._alDonationTypeList = BOL.DonationType.GetDonationTypeLookupList();
			this.cmbType.Items.Clear();
			this.cmbType.Items.Add(string.Empty);				
			
			foreach(Object obj in _alDonationTypeList)
			{
				BOL.DonationType donationType = (BOL.DonationType) obj;
				this.cmbType.Items.Add(donationType.DonationTypeText);
			}
	

			//Testing status list
			this._alTestingStatusList = BOL.TestingStatus.GetTestingStatusLookupList();
			this.cmbTestingStatus.Items.Clear();
			this.cmbTestingStatus.Items.Add(string.Empty);
			foreach(string sTestingStatus in this._alTestingStatusList)
			{
				int nComma = sTestingStatus.IndexOf(",");
				string sText = sTestingStatus.Substring(nComma + 1); 
				cmbTestingStatus.Items.Add(sText);
			}
		

			//ABORh list
			this.cmbABORh.LoadValues();

			this._isLoading = false;
		}
		
		/// <summary>
		/// Controls the enabling and disabling of the OK button
		/// </summary>	
		///<remarks>
		///<newpara> Function Name: tmrSaveEnabled_Tick</newpara>
		///<newpara> Developers: Cameron Taylor</newpara>
		///<newpara> Site Name: Hines OIFO </newpara>
		///<newpara> Date Created: 4/30/2002</newpara>
		///<newpara> Handles: tmrSaveEnabled Tick Event</newpara>
		///</remarks>
		///<param name="sender">Object</param>
		///<param name="e">System.Eventargs</param>
		///
		private void tmrSaveEnabled_Tick(object sender, System.EventArgs e)
		{
		}

		/// <summary>
		/// Standard event handler for Enter event
		/// </summary>		
		///<remarks>
		///<newpara> Function Name: Enter</newpara>
		///<newpara> Developers: Cameron Taylor</newpara>
		///<newpara> Site Name: Hines OIFO </newpara>
		///<newpara> Date Created: 4/30/2002</newpara>
		///<newpara> Handles: Enter event for txtFDAReg, txtUnitID, txtExpiration, txtProduct, cmbABORh</newpara>
		///</remarks>
		///<param name="sender">Object. </param>
		///<param name="e">System.Eventargs. </param>
		///
		private new void Enter(object sender, System.EventArgs e)
		{
            System.Windows.Forms.Control _senderControl= (System.Windows.Forms.Control)sender;
            pictureBox2.Visible = false;
			pictureBox3.Visible = false;
			pictureBox4.Visible = false;
			pictureBox5.Visible = false;
			pictureBox6.Visible = false;
			
            //Defect 227411
            using (Font _tmpFontRegular = new Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0))))	
            {			       
                    lblFDAReg.Font = _tmpFontRegular;
			        lblABORh.Font = _tmpFontRegular;
			        lblExpiration.Font = _tmpFontRegular;
			        lblProduct.Font = _tmpFontRegular;
			        lblUnitID.Font = _tmpFontRegular;
			        try
			        {
				        ((TextBox)_senderControl).SelectAll();
			        }
			        catch(Exception /*e*/)
			        {
			        }
            }
            using (Font _tmpFontBold = new Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0))))	
            {
			        switch (_senderControl.Name)
			        {
				        case "txtFDAReg":
					        pictureBox2.Visible = true;
					        lblFDAReg.Font = _tmpFontBold;
					        break;
				        case "txtUnitID":
					        pictureBox3.Visible = true;
					        lblUnitID.Font = _tmpFontBold;
					        break;
				        case "cmbABORh":
					        pictureBox4.Visible = true;
					        lblABORh.Font = _tmpFontBold;
					        break;
				        case "txtProduct":
					        pictureBox5.Visible = true;
					        lblProduct.Font = _tmpFontBold;
					        break;
				        case "txtExpiration":
					        pictureBox6.Visible = true;
					        lblExpiration.Font = _tmpFontBold;
					        break;
                    }
            }
        
		}

		/// <summary>
		/// Standard Leave Event Code
		/// </summary>	
		///<remarks>
		///<newpara> Function Name: Leave</newpara>
		///<newpara> Developers: Cameron Taylor</newpara>
		///<newpara> Site Name: Hines OIFO </newpara>
		///<newpara> Date Created: 4/30/2002</newpara>
		///<newpara> Handles: Leave event for txtFDAReg, txtUnitID, txtExpiration, txtProduct, cmbABORh</newpara>
		///</remarks>
		///<param name="sender">Object. </param>
		///<param name="e">System.Eventargs. </param>
		///<returns>N/A</returns>
		///
		private new void Leave(object sender, System.EventArgs e)
		{
			
			System.Windows.Forms.Control _senderControl= (System.Windows.Forms.Control)sender;
			pictureBox2.Visible = false;
			pictureBox3.Visible = false;
			pictureBox4.Visible = false;
			pictureBox5.Visible = false;
			pictureBox6.Visible = false;
              //Defect 227411
            using (Font _tmpFontRegular = new Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0))))
            {
                lblFDAReg.Font = _tmpFontRegular;
                lblABORh.Font = _tmpFontRegular;
                lblExpiration.Font = _tmpFontRegular;
                lblProduct.Font = _tmpFontRegular;
                lblUnitID.Font = _tmpFontRegular;
            }
		}

		/// <summary>
		/// Loads blood product properties based on given product code.
		/// </summary>
		/// <param name="productCode"></param>
		private string GetBloodProduct(string productCode)
		{
			try
			{
				this.Working();
	
				_multipleBloodProductCode = new MultipleBloodProductCode(ThisUser, this, productCode);
			
				switch(_multipleBloodProductCode.BloodProductsDataTable.Rows.Count)
				{
					case 0:
						this.Stopped();
						return productCode + " " + Common.StrRes.InfoMsg.Common.CannotAddBloodProduct().ResString;
					case 1:
						this._bloodProduct = _multipleBloodProductCode.BloodProduct;
						this.EnableSpecialTesting(this._bloodProduct.BloodComponentClassId);
						return String.Empty;
					default:
						this._bloodProduct =_multipleBloodProductCode.BloodProduct;
						this.EnableSpecialTesting(_bloodProduct.BloodComponentClassId);
						return string.Empty;
				}


			}
			catch(BOL.TooManyRecordsFoundException _err)
			{
				return _err.Message;
			}
			finally
			{
				this.Ready();
			}
		}

		private bool IsProductActive()
		{
			if( _bloodUnit == null ) return false;

			if (_bloodUnit.ProductShippers.Count == 0)
			{
				_bloodUnit.ProductShippers = new BOL.ProductShipperCollection(_bloodUnit.BloodProductGuid); 
			}

			return (_bloodUnit.IsProductShipperActive(this._shipment.LocalSupplier.LocalSupplierGuid));			
		}

		private void LoadBloodProduct(BOL.BloodProduct bp)
		{
			if( _bloodUnit == null ) return;

			if(bp.BarcodeType != _bloodUnit.BarcodeType)
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.btnProductCode, Common.StrRes.SysErrMsg.UC001.ProductCodeNoMatchShipmentType().ResString);
				this.txtProduct.Focus();
				return;
			}

			//Translate blood product into blood bag
			_bloodUnit.BloodProductGuid = bp.BloodProductGuid;
			_bloodUnit.ProductCode = bp.ProductCode;
			_bloodUnit.ProductShortName = bp.ProductShortName;
			_bloodUnit.ProductName = bp.ProductName;
			_bloodUnit.ProductType.ProductTypeCode = bp.ProductType.ProductTypeCode;
			_bloodUnit.ProductType.ProductTypeText = bp.ProductType.ProductTypeText;
			_bloodUnit.RowVersion = bp.RowVersion;

			_bloodUnit.ProductVolume = bp.ProductVolume;
			//BR 1.50
			_bloodUnit.OriginalVolume = bp.ProductVolume;

			_bloodUnit.MaximumStorageDays = bp.MaximumStorageDays;
			_bloodUnit.MaximumStorageHours = bp.MaximumStorageHours;
			
			_bloodUnit.BarcodeType = bp.BarcodeType;

			//BR 1.01 - 1.02
			if ( !this.IsProductActive() && !ActivateBloodProduct() )
				return; // user was given an opportunity to activate inactive blood product and failed

			//INDY - 06/30/2005 - ProductShipper information is invalid, needs to be reassigned here to ensure valid save

			this._shipment.ProductShipper = _bloodUnit.ProductShippers.GetElementByLocalSupplierGuid(this._shipment.LocalSupplier.LocalSupplierGuid);
			this._shipment.ProductShipperGuid = this._shipment.ProductShipper.ProductShipperGuid;

			_bloodUnit.BloodUnitFinance.LoadDefaultCostInformation(_bloodUnit.ProductShippers, this._shipment.LocalSupplier.LocalSupplierGuid);			
		}
		
		private bool ActivateBloodProduct()
		{
			if( !DAL.VAL.VistALink.EnsureAvailability() )
				return false;

			/***************************************************************************************
				User must have ability to update blood product if it is not active for a shipper.  
				Waiting until UC 8 is refactored to do this, though.  Currently, just displaying 
				an error message
				***************************************************************************************/
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.ActivateEditBloodProductInformation))
			{
				FrmBloodProductEdit _frmBloodProductEdit = new FrmBloodProductEdit(_bloodUnit.BloodProductGuid, this.Shipment.LocalSupplier, this.Codabar);
				
				if (_frmBloodProductEdit.DialogResult != DialogResult.Abort)
				{
					DialogResult result = _frmBloodProductEdit.ShowDialog(this);
							
					if( result == DialogResult.OK && _frmBloodProductEdit.BloodProduct.IsProductShipperActive(this.Shipment.LocalSupplier.LocalSupplierGuid) )
					{
						_bloodUnit.ProductShippers = new BOL.ProductShipperCollection(_bloodUnit.BloodProductGuid); 
						return true;
					}
				}
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("edit blood product information"));
			}

			this.txtProduct.Text = String.Empty;
			this._bloodProduct = null;
			// **** 508 Compliance ***
			this.errError.SetVbecsError(this.btnProductCode, Common.StrRes.SysErrMsg.UC001.ProductNotActive().ResString);
			
			return false;
		}

		#endregion

		private void EnableSpecialTesting(int componentClassID)
		{
			this.specialTesting1.CmvEnabled = true;
			//BR_1.53
			switch (componentClassID)
			{
				case (int) Common.ComponentClass.RBC : case (int) Common.ComponentClass.WB : 
					//Sickle Cell and Antigen Typing is enabled
					this.specialTesting1.SickleCellEnabled = true;
					this.specialTesting1.AntigensEnabled = true;
					break;
				default:
					//Sickle Cell and Antigen Typing is disabled
					this.specialTesting1.SickleCellEnabled = false;
					this.specialTesting1.AntigensEnabled = false;
					break;
			}
		}

		private void EnableDisable(bool enable)
		{
			if(this.Codabar)
			{
				this.txtUnitID.ReadOnly = !enable;
				this.txtProduct.ReadOnly = !enable;
				this.btnProductCode.Enabled = enable;
				this.dtpExpiration.Enabled = enable;
				this.cmbType.Enabled = enable;
				this.updSpecialTestingCost.Enabled = enable;
				this.btnFDARegNo.Enabled = !enable;
				this.txtFDAReg.ReadOnly = enable;

		
				this.specialTesting1.Enabled = enable;
			}
		}

		private void txtFDAReg_Leave(object sender, System.EventArgs e)
		{
			string collectionFacilityError = string.Empty;
			//BR 1.12
			string fdaRegistrationNumber = string.Empty;
			
			if( this.txtFDAReg.Text == string.Empty ) return;
			this.IsDirty = true;
			if(txtFDAReg.Barcode)
			{	
							
				//CR 2759, BR_1.11, The FDA Registration Number is a 7 or 10 numeric code. 
				//When scanned, there may be 2 extra characters. 
				//When the scanner detects 9 or 12 characters,
				//the system should use the inner 7 or 10 characters
				//to search the database to identify the original
				//collection facility. The 7 or 10 digit FDA Registration
				//number is stored. When searching the database for the 
				//matching facility, when the FDA Registration # is 7 characters,
				//the system searches for a match first in the CFN field and if no
				//match then searches for a matching FEI field. When the FDA Registration #
				//is 10 characters, the system searches only for a matching FEI field. The 
				//reference database that lists the CFN and FEI #s for each registered
				//facility is provided by the FDA and is described in PT_6.01.
				if(this.txtFDAReg.Text.Trim().Length == 12 || this.txtFDAReg.Text.Trim().Length == 10)
				{
					fdaRegistrationNumber = this.txtFDAReg.Text.Trim().Length == 12 ? this.txtFDAReg.Text.Trim().Substring(1,10) : this.txtFDAReg.Text.Trim();
				}
				else if(this.txtFDAReg.Text.Trim().Length == 9 || this.txtFDAReg.Text.Trim().Length == 7)
				{
					fdaRegistrationNumber = this.txtFDAReg.Text.Trim().Length == 9 ? this.txtFDAReg.Text.Trim().Substring(1,7) : this.txtFDAReg.Text.Trim();
				}
						
				if(	this.txtFDAReg.Text.Trim().Length == 12 || 
					this.txtFDAReg.Text.Trim().Length == 10 || 
					this.txtFDAReg.Text.Trim().Length == 9 || 
					this.txtFDAReg.Text.Trim().Length == 7)
				{
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, String.Empty);
				}
				else
				{
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, Common.StrRes.InfoMsg.Common.IncorrectBarcode().ResString);
					this.txtFDAReg.Text = string.Empty;
					return;
				}
			}

			try
			{
				//BR 1.11
				fdaRegistrationNumber = this.txtFDAReg.Text.Trim().Length == 9 ? this.txtFDAReg.Text.Trim().Substring(1,7) : this.txtFDAReg.Text.Trim();
				this._localSupplier = new BOL.LocalSupplier(fdaRegistrationNumber, true);
				bool bExists = BOL.LocalSupplier.IsValidFdaRegistrationNumber(fdaRegistrationNumber);

				
				if(bExists)
				{
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, string.Empty);
					if(this._bloodUnit == null)
					{
						this.EnableDisable(true);
					}
					this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC001.NoUnitInstance().ResString);
					//This will tab past the button, since we have found a match already
					this.SelectNextControl(this.btnFDARegNo,true,true,true,true);
					return;
				}
				else if(this._localSupplier.RecordStatusCode == Common.RecordStatusCode.NationalStandard)
				{
					this._localSupplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
					this._localSupplier.InsertLocalSupplier(Common.UpdateFunction.UC001FrmProcessShipmentIn);
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, string.Empty);
				}
				else if(this._localSupplier.RecordStatusCode == Common.RecordStatusCode.Inactive  && !this._localSupplier.IsNew)
				{
					this._localSupplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
					this._localSupplier.UpdateLocalSupplier(Common.UpdateFunction.UC001FrmProcessShipmentIn);
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, string.Empty);
				}
				else if(this._localSupplier.RecordStatusCode == Common.RecordStatusCode.Inactive  && this._localSupplier.IsNew)
				{
					if(GoToUC06(false) != true)
					{
						return;
					}
				}
			}
			catch(BOL.BusinessObjectException xcp)
			{
				// if non-numeric value will be entered CollectionFacility will throw
				// BusinessObjectException
				// **** 508 Compliance ***
				errError.SetVbecsError(this.btnFDARegNo, xcp.Message);
				return;
			}
			this.txtFDAReg.Text = this._localSupplier.FDARegistrationNumber;
			// **** 508 Compliance ***
			this.errError.SetVbecsError(this.btnFDARegNo, string.Empty);
			if(this._bloodUnit == null)
			{
				this.EnableDisable(true);
			}
			this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC001.NoUnitInstance().ResString);
		}
		private bool GoToUC06(bool ISBT)
		{
			string collectionFacilityError = string.Empty;
			FrmCollectionFacilityMaintain f;

			//Clear error providers
			// **** 508 Compliance ***
			this.errError.SetVbecsError(btnFDARegNo, collectionFacilityError);
			this.errError.SetVbecsError(this.txtUnitID, collectionFacilityError);
			
			string iccbba = string.Empty;
			if(ISBT)
			{
				if(this.txtUnitID.Text.IndexOf("=") > -1)
				{
					iccbba = this.txtUnitID.Text.Substring(1,5);
					f = new FrmCollectionFacilityMaintain(iccbba, true);
				}
				else
				{
					iccbba = this.txtUnitID.Text.Substring(0,5);
					f = new FrmCollectionFacilityMaintain(iccbba, true);
				}
			}
			else
			{
				int nLen = this.txtFDAReg.Text.Trim().Length;
				if(nLen != 10 && nLen != 7)
				{
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, "Invalid FDA Registration");
					return false;
				}
				f = new FrmCollectionFacilityMaintain(this.txtFDAReg.Text);
			}
			if (BOL.LocalSupplier.IsNewFDARegistrationNumber(this.txtFDAReg.Text) && !f.HasAuthorityToAdd())
			{
				return false;		
			}
			DialogResult dialogResult = f.ShowDialog(this);
			
			if (dialogResult != DialogResult.OK) 
			{	
				if(f.LocalSupplier != null)
				{
					if(f.LocalSupplier.RecordStatusCode == Common.RecordStatusCode.NationalStandard)
					{
						collectionFacilityError = Common.StrRes.SysErrMsg.Common.NoCollectionFacilityFound(this.txtFDAReg.Text).ResString;
					}
					else
					{
						collectionFacilityError = Common.StrRes.SysErrMsg.Common.AddNewCollectionFacility(this.txtFDAReg.Text).ResString;
					}
				}
				else
				{
					collectionFacilityError = Common.StrRes.SysErrMsg.Common.AddNewCollectionFacility(this.txtFDAReg.Text).ResString;
				}
				if(ISBT)
				{
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.txtUnitID, collectionFacilityError);
				}
				else
				{
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, collectionFacilityError);
				}
				if(collectionFacilityError.Length > 0)
				{
					return false;
				}
				return true;
			}
				//If they clicked OK but did not make it local then
			else
			{
				if(ISBT)
				{
					try
					{
						this._localSupplier = new BOL.LocalSupplier(true,iccbba);
					}
					catch(BOL.BusinessObjectException exp)
					{
						// **** 508 Compliance ***
						this.errError.SetVbecsError(this.txtUnitID, exp.Message);
						return false;
					}
					if(f.LocalSupplier != null)
					{
						if(this._localSupplier.IccbbaRegistrationNumber != f.LocalSupplier.IccbbaRegistrationNumber)
						{
							collectionFacilityError = Common.StrRes.SysErrMsg.Common.AddNewCollectionFacility(this.txtFDAReg.Text).ResString;
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.txtUnitID, collectionFacilityError);
							return false;
						}
					}
				}
				else
				{
					try
					{
						this._localSupplier = new BOL.LocalSupplier(this.txtFDAReg.Text, true);
					}
						//BOL validates valid FDA reg format if invalid throws this type of exception
					catch(BOL.BusinessObjectException exp)
					{
						// **** 508 Compliance ***
						this.errError.SetVbecsError(this.txtFDAReg, exp.Message);
						return false;
					}
				}
				if(this._localSupplier != null)
				{
					if(this._localSupplier.RecordStatusCode != Common.RecordStatusCode.LocalEntry)
					{
						if(ISBT)
						{
							collectionFacilityError = Common.StrRes.SysErrMsg.Common.NoCollectionFacilityFound(this.txtUnitID.Text).ResString;
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.txtUnitID, collectionFacilityError);
						}
						else
						{
							collectionFacilityError = Common.StrRes.SysErrMsg.Common.NoCollectionFacilityFound(this.txtFDAReg.Text).ResString;
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.btnFDARegNo, collectionFacilityError);
						}
						return (collectionFacilityError.Length == 0);
					}
				}
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.txtUnitID, string.Empty);

			}
			this._localSupplier = f.LocalSupplier;
			return true;
		}

		private void txtFDAReg_TextChanged(object sender, System.EventArgs e)
		{
			this.collectionFacilityChecked = 0;
			if( !IsDigitsOnlyString( txtFDAReg.Text ) ) 
				RemoveNonDigitsFromTextBox( txtFDAReg );
			this.IsDirty = true;
			//BR 1.11
			string fdaRegistrationNumber = string.Empty;

		

			if( fdaRegistrationNumber.Trim().Length == 0 ) return;

			if(this.txtFDAReg.Text.Trim() != fdaRegistrationNumber.Trim())
			{
				this.txtFDAReg.Text = fdaRegistrationNumber;
			}

			if( _bloodUnit == null ) return;

			try
			{
				if (this.txtFDAReg.Text == string.Empty || this.txtFDAReg.Text.Length <= 6) return;

				this._bloodUnit.UnitFdaRegistrationNumber = fdaRegistrationNumber;

				if (this.txtFDAReg.Text.Length == 9)
				{
					this.txtFDAReg.Text = fdaRegistrationNumber;
				}
			}
			catch (IndexOutOfRangeException)
			{
				if (collectionFacilityChecked == 0)
				{
					this.txtFDAReg.SelectAll();
					//BR 1.12
					string noCollectionFacilityError = Common.StrRes.SysErrMsg.Common.NoCollectionFacilityFound(this.txtFDAReg.Text).ResString;
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, noCollectionFacilityError);
					collectionFacilityChecked++;
				}
				else
				{
					FrmCollectionFacilityMaintain f = new FrmCollectionFacilityMaintain(this.txtFDAReg.Text);
					f.ShowDialog(this);
					this._bloodUnit.LocalSupplier = f.LocalSupplier;
					this._bloodUnit.LocalSupplier.FDARegistrationNumber = this._bloodUnit.UnitFdaRegistrationNumber;
					this.txtFDAReg.Text = this._bloodUnit.UnitFdaRegistrationNumber;
					collectionFacilityChecked = 0;
					// **** 508 Compliance ***
					this.errError.SetVbecsError(this.btnFDARegNo, string.Empty);

					this.bloodUnitLabel1.Refresh();	
					this.txtFDAReg_Leave(sender, e);
					this.txtUnitID.Focus();
				}
			}
				//BOL validates valid FDA reg and if invalid throws this type of exception
			catch(BOL.BusinessObjectException err)
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.btnFDARegNo,err.Message);
			}
		}

			
		
		/// <summary>
		/// Checks if a string passed in can be converted to an integer number. 
		/// Basically, checks if a string consists of digits only. 
		/// </summary>
		/// <param name="s">String to check</param>
		/// <returns>
		///		True if string consists of digits and leading/trailing 
		///		spaces only. Otherwise - false.
		///	</returns>
		private bool IsDigitsOnlyString( string s )
		{
			double a;
			return Double.TryParse(txtFDAReg.Text, System.Globalization.NumberStyles.Integer, Application.CurrentCulture.NumberFormat, out a );
		}

		/// <summary>
		/// Removes all non-digit characters from the text box and
		/// moves cursor to the end of the string.
		/// </summary>
		/// <param name="txtBox">Text box to clean up</param>
		private void RemoveNonDigitsFromTextBox( TextBox txtBox )
		{
			string srcStr = txtBox.Text;

			if( srcStr == String.Empty ) return;

			System.Text.StringBuilder sb = new System.Text.StringBuilder();

			for( int i = 0; i < srcStr.Length; i++ )
				if( Char.IsDigit( srcStr[i] ) )
					sb.Append( srcStr[i] );

			txtBox.Text = sb.ToString();
			txtBox.AppendText( String.Empty ); // to put cursor at the end
		}

		

	

		private void txtProduct_TextChanged(object sender, System.EventArgs e)
		{

			TrimManuallyEnteredProductCode();

			if(this._bloodUnit != null)
			{
				string sDonationTypeCode = string.Empty;
				if (this.txtProduct.Text.Trim().Length > 4)
				{
					this.IsDirty = true;
					try
					{
						_bloodUnit.ProductCode = txtProduct.Text;
					}
					catch (BOL.BusinessObjectException ex)
					{
						// **** 508 Compliance ***
						errError.SetVbecsError(this.btnProductCode, ex.Message);
						return;
					}
					if(!this.Codabar)
					{
						if(this.txtProduct.Text.Trim().Length > 5)
						{
							sDonationTypeCode = this.txtProduct.Text.Substring(5, 1);
							try
							{
								this._bloodUnit.DonationType.DonationTypeCode = sDonationTypeCode.ToCharArray()[0];
							}
							catch (BOL.BusinessObjectException ex)
							{
								// **** 508 Compliance ***
								errError.SetVbecsError(this.btnProductCode, ex.Message);
								return;
							}
						}
						this.cmbType.Text = this._bloodUnit.DonationType.DonationTypeText;
						if(this.cmbType.Text != this._bloodUnit.DonationType.DonationTypeText)
						{
							if(sDonationTypeCode != "0")
							{
								this.HandlecmbTypeChange();
							}
						}
					}
				}
			}
		}

		/// <summary>
		/// Checks if product code was entered manually and trims 
		/// it to appropriate length if required
		/// </summary>
		private void TrimManuallyEnteredProductCode()
		{
			if( txtProduct.Barcode ) return;

			int _maxCodeLength = this.Codabar ? 5 : 8;

			if( this.txtProduct.Text.Trim().Length > _maxCodeLength )
				this.txtProduct.Text = this.txtProduct.Text.Substring(0, _maxCodeLength);				
		}
				
		/// <summary>
		/// Loads initial broken rules for the this._bloodUnit
		/// </summary>
		private void SetFormBoundBloodUnitInitialBrokenRules()
		{
			string brokenRuleSubsetPrefix = codabar ? "Codabar" : "ISBT128";

			_bloodUnit.SetInitialBrokenRules( this.Name, brokenRuleSubsetPrefix + "_BloodUnit" );
			try
			{
				_bloodUnit.BloodUnitMedia.SetInitialBrokenRules( this.Name, "BloodUnitMedia" );
				_bloodUnit.BloodUnitMedia.AboRh.SetInitialBrokenRules( this.Name, brokenRuleSubsetPrefix + "_ABORh" );
				_bloodUnit.DonationType.SetInitialBrokenRules(this.Name, brokenRuleSubsetPrefix + "_DonationType");
				_bloodUnit.BloodUnitFinance.SetInitialBrokenRules( this.Name, "BloodUnitFinance" );
			}
			catch
			{
				if(this._bloodUnit == null)
				{
					this.Clear();
					return;
				}
			}

		}

		#region Properties

		/// <summary>
		/// Get/Set Codabar
		/// </summary>
		public bool Codabar
		{
			get { return codabar; }
			set 
			{
				codabar = value;
				this.txtFDAReg.Enabled = codabar;
				this.btnFDARegNo.Enabled = codabar;
				this.EnableDisable(false);
				
				if( _bloodUnit == null ) return;
				
				_bloodUnit.BarcodeType = value ? Common.BarcodeType.Codabar : Common.BarcodeType.ISBT128;
			}
		}

		/// <summary>
		/// Get/Set Shipment
		/// </summary>
		public BOL.IncomingShipment Shipment
		{
			get 
			{
				return this._shipment;
			}
			set
			{
				this._shipment = value;
				if(this._shipment.ShipmentGuid != System.Guid.Empty)
				{
					PopulateExistingBloodUnitsInListView();
				}
				invoiceDisplayPanel1.Shipment = this._shipment;
			}
		}

		/// <summary>
		/// Get/Set ProcessingTechId
		/// </summary>
		public string ProcessingTechId
		{
			get
			{
				return this._processingTechID;
			}
			set
			{
				this._processingTechID = value;
			}
		}	

		private void PopulateExistingBloodUnitsInListView()
		{
			System.Collections.ArrayList alBloodUnits = BOL.BloodUnit.GetIncomingShipmentBloodUnitsString(this.Shipment.ShipmentGuid);

			this.AddToListViewAL(alBloodUnits);
		}

		#endregion

	

		

		private void txtProduct_Leave_1(object sender, System.EventArgs e)
		{

			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					if(this.txtProduct.Text.Trim().Length == 0)
					{
						this.txtProduct.Text = String.Empty;
						return;
					}
					if(!this.txtProduct.ProductCodeValid)
					{
						// **** 508 Compliance ***
						this.errError.SetVbecsError(this.btnProductCode, Common.StrRes.InfoMsg.Common.IncorrectBarcode().ResString);
						this.txtProduct.Text = String.Empty;
						return;
					}
					else
					{
						// **** 508 Compliance ***
						this.errError.SetVbecsError(this.btnProductCode, String.Empty);
					}
			
					TrimManuallyEnteredProductCode();
					string error = string.Empty;
					if(this._bloodProduct == null)
					{
						error = this.GetBloodProduct(this.txtProduct.Text.Trim());
					}
					else
					{
						if(this.Codabar)
						{
							if(this.txtProduct.Text.Trim() != this._bloodProduct.ProductCode)
							{
								error = this.GetBloodProduct(this.txtProduct.Text.Trim());
							}
						}
						else
						{
							if(this.txtProduct.Text.Trim() != this._bloodProduct.ProductCode  + this._bloodProduct.DonationType.DonationTypeCode + this._bloodProduct.UnitDivisionId)
							{
								error = this.GetBloodProduct(this.txtProduct.Text.Trim());
							}
						}
					}
					if(this._bloodUnit != null)
					{
						if(this.txtProduct.Text.Trim() != this._bloodUnit.FullProductCode)
						{
							error = this.GetBloodProduct(this.txtProduct.Text.Trim());
						}
					}
					if(error != string.Empty)
					{
						// **** 508 Compliance ***
						this.errError.SetVbecsError(this.btnProductCode, error);
						return;
					}
					else
					{
						GetNewBloodUnit();
						if(this._bloodUnit != null)
						{
							this.LoadBloodProduct(this._bloodProduct);
						}
					}
	
	

					if( this._bloodUnit != null )
					{
						
						if(!this._bloodUnit.ProductActiveIndicator)
						{
							// **** 508 Compliance ***
							this.errError.SetVbecsError(this.btnProductCode, "Product not active in division.");
							return;
						}
						this.HandleProductCodeLeave();
						this.HandleUnitIDLeave();
					}
				}
				finally
				{
					this.CheckValid(sender, e);
					this.RecursionGuard = false;
				}
			}
		}

		private void btnFDARegNo_Click_1(object sender, System.EventArgs e)
		{

			DlgFacilitySearch dlg = new DlgFacilitySearch(this.txtFDAReg.Text);

			dlg.ShowDialog(this);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this.txtFDAReg.Text = dlg.FdaRegistrationNumber;
				this.txtFDAReg_Leave(sender,e);
			}
		}

		private void btnProductCode_Click_1(object sender, System.EventArgs e)
		{

			DlgBloodProductSelect dlg = new DlgBloodProductSelect(this.Codabar);

			dlg.ShowDialog(this);
			
			if (dlg.DialogResult == DialogResult.OK)
			{
				
				if(dlg.BloodProduct.UnitDivisionId == string.Empty)
				{
					this.txtProduct.Text = dlg.BloodProduct.ProductCode + dlg.BloodProduct.DonationType.DonationTypeCode + "00";
				}
				else
				{
					this.txtProduct.Text = dlg.BloodProduct.ProductCode + dlg.BloodProduct.DonationType.DonationTypeCode + dlg.BloodProduct.UnitDivisionId;
				}
				this.txtProduct.Focus();
			}
		}

		private void FrmProcessShipmentIn_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			_isUnloading = true;
		}

		private void CallHandleExpirationDate()
		{
			if(!this.dtpExpiration.CorrectBarcode)
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.dtpExpiration, Common.StrRes.InfoMsg.Common.IncorrectBarcode().ResString);
				this.dtpExpiration.ClearDateText();
				return;
			}
			else
			{
				// **** 508 Compliance ***
				this.errError.SetVbecsError(this.dtpExpiration, String.Empty);
			}

			if(this._bloodUnit != null)
			{
				this.HandleExpirationDateLeave();
			}
		}

		private void updSpecialTestingCost_Leave(object sender, System.EventArgs e)
		{
			this.HandleSpecialTestingCostLeave();
		}		
		
		private void updSpecialTestingCost_ValueChanged(object sender, System.EventArgs e)
		{
			this.HandleSpecialTestingCostChanged();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmProcessShipmentIn_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if(this._bloodUnit == null)
			{
				textToSpeak = this.btnAdd.GetToolTip();
			}
			else
			{
				textToSpeak = GetAddButtonToolTip();
			}
			//
			this.SpeakMessage( textToSpeak );
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		private string GetAddButtonToolTip()
		{
			string message = string.Empty;
			//
			if(this._bloodUnit != null) 
			{
				if(_transferredOutandInConfirmed && this.txtPatient.Text == string.Empty && ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator==false)
				{
					message = "A patient must be choosen.";	
				}
				else if ( (_bloodUnit.IsValid && _bloodUnit.BloodUnitMedia.AboRh.IsValid && _bloodUnit.DonationType.IsValid 
					&& _bloodUnit.BloodUnitMedia.IsValid && _bloodUnit.BloodUnitFinance.IsValid) 
					&& errError.GetError(this.txtUnitID).Length == 0)
				{
					message = Common.StrRes.SysErrMsg.UC001.AddUnitToList().ResString;
				}
				else 
				{
					message = Common.Utility.SumBrokenRulesMessages( 
						_bloodUnit.GetBrokenRulesMessage(this.Name),
						_bloodUnit.BloodUnitMedia.AboRh.GetBrokenRulesMessage(this.Name),
						_bloodUnit.BloodUnitMedia.GetBrokenRulesMessage(this.Name),
						_bloodUnit.BloodUnitFinance.GetBrokenRulesMessage(this.Name),
						_bloodUnit.DonationType.GetBrokenRulesMessage(this.Name) );
				}

			}
			else
			{
				if(Codabar && this.txtFDAReg.Text.Length < 7)
				{
					message = Common.StrRes.Tooltips.UC01.CodabarNoUnitInstance().ResString;
				}
				else
				{
					message = Common.StrRes.Tooltips.UC001.NoUnitInstance().ResString;
				}
			}
			
			//
			return message;
		}

	}
}
